/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.user;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.UserManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.rbac.user.DeleteUserCallInput;

@Singleton
public class DeleteUserCall
implements Call<DeleteUserCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public DeleteUserCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(DeleteUserCallInput input) {
        try {
            this.deleteUserRest(input);
            return DefaultCallOutput.success("User " + input.username() + " deleted");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.url()));
        }
    }

    private void deleteUserRest(DeleteUserCallInput input) throws ApiException {
        new UserManagementApi(this.apiClientFactory.getClient(input.url())).deleteUser(input.username());
    }
}

