/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.role;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.RoleManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.Role;
import org.gridgain.internal.cli.call.rbac.role.CreateRoleCallInput;

@Singleton
public class CreateRoleCall
implements Call<CreateRoleCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public CreateRoleCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(CreateRoleCallInput input) {
        String clusterUrl = input.url();
        try {
            this.createUserRest(clusterUrl, input.roleName());
            return DefaultCallOutput.success("Role " + input.roleName() + " created");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private void createUserRest(String clusterUrl, String roleName) throws ApiException {
        new RoleManagementApi(this.apiClientFactory.getClient(clusterUrl)).createRole(new Role().roleName(roleName));
    }
}

