/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.cluster.init;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.ignite.internal.cli.commands.cluster.init.ConfigAsPathException;
import org.apache.ignite.internal.cli.commands.cluster.init.ConfigFileParseException;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public class ClusterInitOptions {
    @CommandLine.Option(names={"--name"}, required=true, description={"Human-readable name of the cluster"}, order=0)
    private String clusterName;
    @CommandLine.Option(names={"--metastorage-group"}, description={"Metastorage group nodes (use comma-separated list of node names '--metastorage-group node1, node2' to specify more than one node) that will host the Meta Storage. If the --cluster-management-group option is omitted, the same nodes will also host the Cluster Management Group."}, split=",", paramLabel="<node name>", order=1, preprocessor=SingleOccurrenceMetastorageConsumer.class)
    private List<String> metaStorageNodes = new ArrayList<String>();
    @CommandLine.Option(names={"--cluster-management-group"}, description={"Names of nodes (use comma-separated list of node names '--cluster-management-group node1, node2' to specify more than one node) that will host the Cluster Management Group. If omitted, then --metastorage-group values will also supply the nodes for the Cluster Management Group."}, split=",", paramLabel="<node name>", order=2, preprocessor=SingleOccurrenceClusterManagementConsumer.class)
    private List<String> cmgNodes = new ArrayList<String>();
    @CommandLine.ArgGroup
    private ClusterConfigOptions clusterConfigOptions;
    @CommandLine.Option(names={"--license"}, required=true, description={"License file."}, order=5)
    private Path license;

    public List<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    public List<String> cmgNodes() {
        return this.cmgNodes;
    }

    public String clusterName() {
        return this.clusterName;
    }

    @Nullable
    public String clusterConfiguration() {
        if (this.clusterConfigOptions == null) {
            return null;
        }
        if (this.clusterConfigOptions.config != null) {
            String config = this.clusterConfigOptions.config;
            if (ClusterInitOptions.tryParseConfig(config)) {
                return config;
            }
            if (ClusterInitOptions.checkConfigAsPath(config)) {
                throw new ConfigAsPathException(config);
            }
            return config;
        }
        if (this.clusterConfigOptions.files != null) {
            Config config = ConfigFactory.empty();
            for (File file : this.clusterConfigOptions.files) {
                try {
                    String content = Files.readString(file.toPath());
                    config = config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)content));
                }
                catch (IOException e) {
                    throw new IgniteCliException("Couldn't read cluster configuration file " + file, e);
                }
                catch (ConfigException e) {
                    throw new ConfigFileParseException("Couldn't parse cluster configuration file " + file, e);
                }
            }
            return config.root().render(ConfigRenderOptions.concise().setFormatted(true).setJson(true));
        }
        return null;
    }

    public String licenseContent() {
        if (this.license == null) {
            return "";
        }
        try {
            String licenseFileContent = Files.readString(this.license);
            Config cfg = ConfigFactory.parseString((String)licenseFileContent);
            if (this.isHoconLicense(cfg)) {
                return ClusterInitOptions.convertConfigToJson(cfg);
            }
            return licenseFileContent;
        }
        catch (ConfigException | IOException e) {
            throw new IgniteCliException("Couldn't read license file " + this.license, e);
        }
    }

    private boolean isHoconLicense(Config cfg) {
        return cfg.hasPath("ignite.license.content") && cfg.hasPath("ignite.license.signature");
    }

    private static String convertConfigToJson(Config cfg) {
        String content = cfg.getConfig("ignite").getConfig("license").getString("content");
        String signature = cfg.getConfig("ignite").getConfig("license").getString("signature");
        Map<String, String> signaturesMap = Map.of("signature_1", signature);
        Config jsonConfig = ConfigFactory.parseString((String)content).withValue("signatures", ConfigValueFactory.fromAnyRef(signaturesMap));
        return jsonConfig.root().render(ConfigRenderOptions.concise());
    }

    String readConfigAsPath() {
        if (this.clusterConfigOptions == null || this.clusterConfigOptions.config == null) {
            throw new ConfigFileParseException("Couldn't parse cluster configuration file.");
        }
        Path file = Paths.get(this.clusterConfigOptions.config, new String[0]);
        try {
            String content = Files.readString(file);
            return ConfigFactory.parseString((String)content).root().render(ConfigRenderOptions.concise().setFormatted(true).setJson(true));
        }
        catch (IOException e) {
            throw new IgniteCliException("Couldn't read cluster configuration file " + file, e);
        }
        catch (ConfigException e) {
            throw new ConfigFileParseException("Couldn't parse cluster configuration file " + file, e);
        }
    }

    private static boolean tryParseConfig(String config) {
        try {
            ConfigFactory.parseString((String)config);
            return true;
        }
        catch (ConfigException e) {
            return false;
        }
    }

    private static boolean checkConfigAsPath(String config) {
        try {
            Path path = Paths.get(config, new String[0]);
            return Files.exists(path, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    private static class ClusterConfigOptions {
        @CommandLine.Option(names={"--config"}, description={"Cluster configuration that will be applied during the cluster initialization"}, order=3, defaultValue="_NULL_")
        private String config;
        @CommandLine.Option(names={"--config-files"}, description={"Path to cluster configuration files (use comma-separated list of paths '--config-files path1, path2' to specify more than one file)"}, split=",", order=4, paramLabel="<file path>", defaultValue="_NULL_")
        private List<File> files;

        private ClusterConfigOptions() {
        }
    }

    private static class SingleOccurrenceMetastorageConsumer
    implements CommandLine.IParameterPreprocessor {
        private final DuplicatesChecker checker = new DuplicatesChecker("--metastorage-group");

        private SingleOccurrenceMetastorageConsumer() {
        }

        public boolean preprocess(Stack<String> args, CommandLine.Model.CommandSpec commandSpec, CommandLine.Model.ArgSpec argSpec, Map<String, Object> info) {
            return this.checker.hasDuplicate(args);
        }
    }

    private static class SingleOccurrenceClusterManagementConsumer
    implements CommandLine.IParameterPreprocessor {
        private final DuplicatesChecker checker = new DuplicatesChecker("--cluster-management-group");

        private SingleOccurrenceClusterManagementConsumer() {
        }

        public boolean preprocess(Stack<String> args, CommandLine.Model.CommandSpec commandSpec, CommandLine.Model.ArgSpec argSpec, Map<String, Object> info) {
            return this.checker.hasDuplicate(args);
        }
    }

    private static class DuplicatesChecker {
        private final String optionToCheck;

        private DuplicatesChecker(String optionToCheck) {
            this.optionToCheck = optionToCheck;
        }

        private boolean hasDuplicate(List<String> args) {
            String[] arr;
            for (String str : arr = (String[])args.toArray(String[]::new)) {
                if (!this.optionToCheck.equals(str.trim())) continue;
                return true;
            }
            return false;
        }
    }
}

