/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.distribution;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.distribution.ResetDistributionCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.DistributionApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.ResetDistributionRequest;

@Singleton
public class ResetDistributionCall
implements Call<ResetDistributionCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ResetDistributionCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<String> execute(ResetDistributionCallInput input) {
        DistributionApi client = new DistributionApi(this.clientFactory.getClient(input.clusterUrl()));
        ResetDistributionRequest command = new ResetDistributionRequest();
        command.setZoneNames(input.zoneNames());
        try {
            client.reset(command);
            return DefaultCallOutput.success("Successfully reset partitions distribution.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

