/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.dcr.ReplicationNameCallInput;
import org.gridgain.internal.cli.call.dcr.ReplicationStatusCall;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import org.gridgain.internal.cli.decorators.ReplicationInfoDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Status data center replication."})
public class DcReplicationStatusCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ReplicationStatusCall replicationStatusCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.replicationStatusCall).inputProvider(() -> ReplicationNameCallInput.builder().replicationName(this.name.replicationName()).clusterUrl(this.clusterUrl.getClusterUrl()).build()).decorator(new ReplicationInfoDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot show replication status")));
    }
}

