/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.dcr.ListReplicationCall;
import org.gridgain.internal.cli.call.dcr.ListReplicationCallInput;
import org.gridgain.internal.cli.decorators.ReplicationInfoListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all replications in the cluster."})
public class DcReplicationListCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ListReplicationCall listReplicationCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.listReplicationCall).inputProvider(() -> ListReplicationCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).build()).decorator(new ReplicationInfoListDecorator(this.plain)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot list replications")));
    }
}

