/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.source;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.rest.client.model.SourceType;
import org.gridgain.internal.cli.call.cdc.source.SourceCallInput;
import org.gridgain.internal.cli.call.cdc.source.UpdateSourceCall;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"CDC source update command."})
public class CdcSourceUpdateCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @Inject
    private UpdateSourceCall updateSourceCall;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC source."})
    private String name;
    @CommandLine.Option(required=true, names={"--type"}, description={"Type of the CDC source."})
    private SourceType type;
    @CommandLine.Option(names={"--parameters"}, description={"Comma-separated key-value pairs of parameters for the source. For example: 'param1=value1,param2=value2'. If not set, then default parameters will be used."})
    private Map<String, Object> parameters;
    @CommandLine.Option(required=true, names={"--tables"}, description={"Comma-separated fully-qualified table names that will be parts of the source."})
    private List<String> tables;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.updateSourceCall).inputProvider(() -> SourceCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).name(this.name).type(this.type).parameters(this.parameters).tables(this.tables).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot update source")));
    }
}

