/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.source;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.CdcManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.Source;
import org.gridgain.internal.cli.call.cdc.source.SourceCallInput;

@Singleton
public class UpdateSourceCall
implements Call<SourceCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public UpdateSourceCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(SourceCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).updateSource(input.name(), new Source().type(input.type()).name(input.name()).parameters(input.params()).tables(input.tables()));
            return DefaultCallOutput.success("Source " + input.name() + " updated.");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

