/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.replication;

import java.util.List;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.apache.ignite.rest.client.model.ReplicationMode;

public class CreateCdcReplicationCallInput
implements CallInput {
    private final String clusterUrl;
    private final String name;
    private final String sourceName;
    private final String sinkName;
    private final ReplicationMode mode;
    private final List<String> executionNodes;

    private CreateCdcReplicationCallInput(String name, String sourceName, String sinkName, String clusterUrl, ReplicationMode mode, List<String> executionNodes) {
        this.clusterUrl = clusterUrl;
        this.name = name;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.mode = mode;
        this.executionNodes = executionNodes;
    }

    public String name() {
        return this.name;
    }

    public String sinkName() {
        return this.sinkName;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public String clusterUrl() {
        return this.clusterUrl;
    }

    public ReplicationMode mode() {
        return this.mode;
    }

    public List<String> executionNodes() {
        return this.executionNodes;
    }

    public static CdcReplicationCallInputBuilder builder() {
        return new CdcReplicationCallInputBuilder();
    }

    public static class CdcReplicationCallInputBuilder {
        private String name;
        private String sinkName;
        private String sourceName;
        private String clusterUrl;
        private ReplicationMode mode = ReplicationMode.ALL;
        private List<String> executionNodes = List.of();

        public CdcReplicationCallInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CdcReplicationCallInputBuilder replicationName(String replicationName) {
            this.sinkName = replicationName;
            return this;
        }

        public CdcReplicationCallInputBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public CdcReplicationCallInputBuilder sinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public CdcReplicationCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        public CdcReplicationCallInputBuilder mode(ReplicationMode mode) {
            this.mode = mode;
            return this;
        }

        public CdcReplicationCallInputBuilder executionNodes(List<String> executionNodes) {
            if (executionNodes == null) {
                return this;
            }
            this.executionNodes = executionNodes;
            return this;
        }

        public CreateCdcReplicationCallInput build() {
            return new CreateCdcReplicationCallInput(this.name, this.sourceName, this.sinkName, this.clusterUrl, this.mode, this.executionNodes);
        }
    }
}

