/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.role;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRevokeCallInput;
import org.gridgain.internal.cli.call.rbac.assignments.RevokeRoleCall;
import picocli.CommandLine;

@CommandLine.Command(name="revoke", description={"Revoke role from user"})
public class UserRoleRevokeCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--from"}, description={"From username"}, required=true, split=",")
    private List<String> username;
    @CommandLine.Option(names={"--role", "-r"}, description={"Role name"}, required=true, split=",")
    private List<String> roleName;
    @Inject
    private RevokeRoleCall revokeRoleCall;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.revokeRoleCall).inputProvider(() -> AssignRevokeCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).roleNames(this.roleName).usernames(this.username).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot revoke role")));
    }
}

