/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.upgrade;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.upgrade.UpgradeStartCall;
import org.gridgain.internal.cli.call.upgrade.UpgradeStartCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start rolling upgrade process."})
public class UpgradeStartCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--version"}, description={"New version. For example, 9.1.1"}, required=true)
    private String version;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private UpgradeStartCall upgradeStartCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.upgradeStartCall).inputProvider(() -> new UpgradeStartCallInput(this.clusterUrl.getClusterUrl(), this.version)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot start upgrade")));
    }
}

