/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.dcr.StartStopReplicationCallInput;
import org.gridgain.internal.cli.call.dcr.StopReplicationCall;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import org.gridgain.internal.cli.commands.dcr.DcReplicationTableArgsGroup;
import org.gridgain.internal.cli.decorators.ReplicationInfoDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="stop", description={"Stop data center replication."})
public class DcReplicationStopReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @CommandLine.Option(names={"--schema"}, description={"Schema name. For example, PUBLIC."})
    private String schema;
    @CommandLine.ArgGroup(multiplicity="1")
    DcReplicationTableArgsGroup tableArgs;
    @Inject
    private StopReplicationCall stopReplicationCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.stopReplicationCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot stop replication")).print(new ReplicationInfoDecorator(this.plain)));
    }

    private StartStopReplicationCallInput input(String url) {
        return StartStopReplicationCallInput.builder().clusterUrl(url).replicationName(this.name.replicationName()).schema(this.schema).tables(this.tableArgs.tableNames()).allTables(this.tableArgs.all()).build();
    }
}

