/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.dcr.ListReplicationCall;
import org.gridgain.internal.cli.call.dcr.ListReplicationCallInput;
import org.gridgain.internal.cli.decorators.ReplicationInfoListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all replications in the cluster."})
public class DcReplicationListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ListReplicationCall listReplicationCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.listReplicationCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list replications")).print(new ReplicationInfoListDecorator(this.plain)));
    }

    private ListReplicationCallInput input(String url) {
        return ListReplicationCallInput.builder().clusterUrl(url).build();
    }
}

