/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.snapshot;

import jakarta.inject.Singleton;
import java.util.UUID;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.SnapshotManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.DeleteCommand;
import org.gridgain.internal.cli.call.snapshot.SnapshotDeleteCallInput;

@Singleton
public class SnapshotDeleteCall
implements Call<SnapshotDeleteCallInput, String> {
    private final ApiClientFactory clientFactory;

    public SnapshotDeleteCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(SnapshotDeleteCallInput input) {
        SnapshotManagementApi client = new SnapshotManagementApi(this.clientFactory.getClient(input.clusterUrl()));
        try {
            UUID operationId = client.delete(new DeleteCommand().snapshotId(input.snapshotId()));
            return DefaultCallOutput.success("Snapshot deletion has been started, operation ID " + operationId);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

