/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.assignments;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.PrivilegesGrantsApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.Privilege;
import org.apache.ignite.rest.client.model.PrivilegeAssignment;
import org.gridgain.internal.cli.call.rbac.assignments.GrantRevokePrivilegeCallInput;
import org.gridgain.internal.cli.call.rbac.privilege.Action;

@Singleton
public class RevokePrivilegeCall
implements Call<GrantRevokePrivilegeCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public RevokePrivilegeCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(GrantRevokePrivilegeCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            this.revokeRest(clusterUrl, input.actions(), input.roleNames(), input.object());
            return DefaultCallOutput.success(RevokePrivilegeCall.formatSuccess(input.actions(), input.roleNames(), input.object()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private void revokeRest(String clusterUrl, List<Action> actions, List<String> roleNames, String object) throws ApiException {
        List<Privilege> privileges = actions.stream().map(action -> new Privilege().action(action.name()).on(object)).collect(Collectors.toList());
        new PrivilegesGrantsApi(this.apiClientFactory.getClient(clusterUrl)).revokePrivileges(new PrivilegeAssignment().privileges(privileges).roleNames(roleNames));
    }

    private static String formatSuccess(List<Action> actions, List<String> roleNames, String object) {
        return (actions.size() == 1 ? "Action " : "Actions ") + actions.stream().map(Enum::name).collect(Collectors.joining(",")) + (String)(object != null ? " on " + object : "") + " revoked from " + (roleNames.size() == 1 ? "role " : "roles ") + String.join((CharSequence)",", roleNames);
    }
}

