/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.commands.TopLevelCliReplCommand;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.apache.ignite.internal.cli.core.exception.handler.DefaultExceptionHandlers;
import org.apache.ignite.internal.cli.core.repl.EventListeningActivationPoint;
import org.apache.ignite.internal.cli.core.repl.Repl;
import org.apache.ignite.internal.cli.core.repl.SessionDefaultValueProvider;
import org.apache.ignite.internal.cli.core.repl.executor.ReplExecutorProvider;
import org.apache.ignite.internal.cli.core.repl.prompt.PromptProvider;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;

@Singleton
public class ReplManager {
    private final ReplExecutorProvider replExecutorProvider;
    private final PromptProvider promptProvider;
    private final SessionDefaultValueProvider defaultValueProvider;
    private final ConnectToClusterQuestion question;
    private final EventListeningActivationPoint eventListeningActivationPoint;
    private final ApiClientFactory apiClientFactory;

    public ReplManager(ReplExecutorProvider replExecutorProvider, PromptProvider promptProvider, SessionDefaultValueProvider defaultValueProvider, ConnectToClusterQuestion question, EventListeningActivationPoint eventListeningActivationPoint, ApiClientFactory apiClientFactory) {
        this.replExecutorProvider = replExecutorProvider;
        this.promptProvider = promptProvider;
        this.defaultValueProvider = defaultValueProvider;
        this.question = question;
        this.eventListeningActivationPoint = eventListeningActivationPoint;
        this.apiClientFactory = apiClientFactory;
    }

    public void subscribe() {
        this.eventListeningActivationPoint.subscribe();
    }

    public void startReplMode() {
        this.replExecutorProvider.get().execute(Repl.builder().withPromptProvider(this.promptProvider).withCommandClass(TopLevelCliReplCommand.class).withDefaultValueProvider(this.defaultValueProvider).withCallExecutionPipelineProvider((executor, exceptionHandlers, line) -> CallExecutionPipeline.builder(executor).inputProvider(() -> new StringCallInput(line)).output(System.out).errOutput(System.err).exceptionHandlers(new DefaultExceptionHandlers()).exceptionHandlers(exceptionHandlers).build()).withOnStart(() -> {
            this.apiClientFactory.tokenAutoRenewEnabled(true);
            this.question.askQuestionOnReplStart();
        }).withHistoryFileName("history").withAutosuggestionsWidgets().build());
    }
}

