/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.decorators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite.internal.cli.util.PlainTableRenderer;
import org.apache.ignite.rest.client.model.ReplicationInfo;
import org.apache.ignite.rest.client.model.TableStatus;
import org.jetbrains.annotations.Nullable;

public class ReplicationInfoDecorator
implements Decorator<ReplicationInfo, TerminalOutput> {
    private final boolean plain;

    public ReplicationInfoDecorator(boolean plain) {
        this.plain = plain;
    }

    @Override
    public TerminalOutput decorate(ReplicationInfo data) {
        if (this.plain) {
            return () -> PlainTableRenderer.render(new String[]{"name", data.getName()}, ReplicationInfoDecorator.content(data));
        }
        return () -> AnsiStringSupport.ansi(" name:        " + AnsiStringSupport.Style.BOLD.mark(data.getName()) + "\n status:      " + ReplicationInfoDecorator.paintStatus(data) + "\n from:        " + data.getSourceClusterName() + "\n to:          " + data.getTargetClusterName() + "\n schema:      " + data.getSchemaName() + "\n tables:      " + ReplicationInfoDecorator.tableStatuses(data.getTableStatuses()) + "\n worker node: " + data.getWorkerNodeName() + "\n fst progress:" + data.getFstProgress() + "%\n" + (String)(data.getErrors() == null ? "" : " errors:      " + String.valueOf(data.getErrors()) + "\n"));
    }

    private static String[][] content(ReplicationInfo data) {
        ArrayList<String[]> res = new ArrayList<String[]>(List.of(new String[]{"status", data.getStatus().toString()}, new String[]{"from", data.getSourceClusterName()}, new String[]{"to", data.getTargetClusterName()}, new String[]{"schema", data.getSchemaName()}, new String[]{"tables", ReplicationInfoDecorator.tableStatuses(data.getTableStatuses())}, new String[]{"worker node", data.getWorkerNodeName()}, new String[]{"fst progress", String.valueOf(data.getFstProgress() + "%")}));
        if (data.getErrors() != null) {
            res.add(new String[]{"errors", data.getErrors().toString()});
        }
        return (String[][])res.toArray((T[])new String[0][0]);
    }

    private static String paintStatus(ReplicationInfo replicationInfo) {
        switch (replicationInfo.getStatus()) {
            case STOPPED: 
            case WORKER_NODE_OUT: {
                return AnsiStringSupport.fg(AnsiStringSupport.Color.YELLOW).mark(replicationInfo.getStatus().toString());
            }
            case FAILED: {
                return AnsiStringSupport.fg(AnsiStringSupport.Color.RED).mark(replicationInfo.getStatus().toString());
            }
            case REPLICATING: {
                return AnsiStringSupport.fg(AnsiStringSupport.Color.GREEN).mark(replicationInfo.getStatus().toString());
            }
        }
        return replicationInfo.getStatus().toString();
    }

    private static String tableStatuses(@Nullable List<TableStatus> tableStatuses) {
        List statuses = Collections.emptyList();
        if (tableStatuses != null) {
            statuses = tableStatuses.stream().sorted(Comparator.comparing(TableStatus::getTable)).map(tableStatus -> tableStatus.getTable() + " | " + String.valueOf((Object)tableStatus.getStatus())).collect(Collectors.toList());
        }
        return Arrays.toString(statuses.toArray());
    }
}

