/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.upgrade.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.upgrade.UpgradeStateCall;
import picocli.CommandLine;

@CommandLine.Command(name="state", description={"Show rolling upgrade state."})
public class UpgradeStateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private UpgradeStateCall upgradeStateCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.upgradeStateCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot show upgrade state")).print());
    }
}

