/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.token.repl;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.token.RevokeTokenCall;
import org.gridgain.internal.cli.call.rbac.token.RevokeTokenCallInput;
import org.gridgain.internal.cli.commands.token.RevokeArgument;
import picocli.CommandLine;

@CommandLine.Command(name="revoke", description={"Revoke token"})
public class RevokeReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private RevokeArgument revokeArgument;
    @Inject
    private RevokeTokenCall revokeTokenCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.revokeTokenCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot revoke token")).print());
    }

    private RevokeTokenCallInput input(String clusterUrl) {
        return RevokeTokenCallInput.builder().clusterUrl(clusterUrl).token(this.revokeArgument.token()).username(this.revokeArgument.username()).build();
    }
}

