/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.sink.repl;

import jakarta.inject.Inject;
import java.util.Map;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.rest.client.model.SinkType;
import org.gridgain.internal.cli.call.cdc.sink.SinkCallInput;
import org.gridgain.internal.cli.call.cdc.sink.UpdateSinkCall;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"CDC sink update command."})
public class CdcSinkUpdateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC sink."})
    private String name;
    @CommandLine.Option(required=true, names={"--type"}, description={"Type of the CDC sink."})
    private SinkType type;
    @CommandLine.Option(names={"--parameters"}, description={"Comma-separated key-value pairs of parameters for the sink. For example: 'param1=value1,param2=value2'. If not set, then default parameters will be used."})
    private Map<String, Object> parameters;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private UpdateSinkCall updateSinkCall;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.updateSinkCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot update sink")).print());
    }

    private SinkCallInput input(String url) {
        return SinkCallInput.builder().clusterUrl(url).name(this.name).type(this.type).parameters(this.parameters).build();
    }
}

