/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.upgrade;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.UpgradeApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.StartUpgradeRequest;
import org.gridgain.internal.cli.call.upgrade.UpgradeStartCallInput;

@Singleton
public class UpgradeStartCall
implements Call<UpgradeStartCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public UpgradeStartCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(UpgradeStartCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            boolean success = new UpgradeApi(this.apiClientFactory.getClient(clusterUrl)).startUpgrade(new StartUpgradeRequest().version(input.version()));
            if (success) {
                return DefaultCallOutput.success("Rolling upgrade has been started.");
            }
            return DefaultCallOutput.failure(new IgniteCliException("Failed to start rolling upgrade."));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

