/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.pitr;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.RecoveryApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.TablesRecoveryStateResponse;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCallInput;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCallOutput;

@Singleton
public class TablesRecoveryStateCall
implements Call<TablesRecoveryStateCallInput, TablesRecoveryStateCallOutput> {
    private final ApiClientFactory clientFactory;

    public TablesRecoveryStateCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<TablesRecoveryStateCallOutput> execute(TablesRecoveryStateCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        try {
            TablesRecoveryStateResponse state = client.getTablesRecoveryState(input.operationId());
            return DefaultCallOutput.success(new TablesRecoveryStateCallOutput(state.getRecoveryProgress(), state.getRecoveryStatus()));
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

