/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.replication;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.CdcManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.Replication;
import org.gridgain.internal.cli.call.cdc.replication.CreateCdcReplicationCallInput;
import org.gridgain.internal.cli.core.exception.AlreadyExistsException;

@Singleton
public class CreateReplicationCall
implements Call<CreateCdcReplicationCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public CreateReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(CreateCdcReplicationCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).createCdcReplication(new Replication().sinkName(input.sinkName()).sourceName(input.sourceName()).name(input.name()).mode(input.mode()).executionNodes(input.executionNodes()));
            return DefaultCallOutput.success("Replication " + input.name() + " created.");
        }
        catch (IllegalArgumentException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
        catch (ApiException e) {
            if (ClusterNotInitializedExceptionHandler.isClusterNotInitialized(e)) {
                return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
            }
            if (e.getCode() == 409) {
                return DefaultCallOutput.failure(new AlreadyExistsException(e));
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

