/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.ignite.rest.client.invoker.JSON;
import org.apache.ignite.rest.client.model.CdcReplicationStatus;
import org.apache.ignite.rest.client.model.ReplicationMode;

public class Replication {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_SINK_NAME = "sinkName";
    @SerializedName(value="sinkName")
    @Nonnull
    private String sinkName;
    public static final String SERIALIZED_NAME_SOURCE_NAME = "sourceName";
    @SerializedName(value="sourceName")
    @Nonnull
    private String sourceName;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    @Nonnull
    private ReplicationMode mode;
    public static final String SERIALIZED_NAME_EXECUTION_NODES = "executionNodes";
    @SerializedName(value="executionNodes")
    @Nonnull
    private List<String> executionNodes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nullable
    private CdcReplicationStatus status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Replication name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Replication sinkName(@Nonnull String sinkName) {
        this.sinkName = sinkName;
        return this;
    }

    @Nonnull
    public String getSinkName() {
        return this.sinkName;
    }

    public void setSinkName(@Nonnull String sinkName) {
        this.sinkName = sinkName;
    }

    public Replication sourceName(@Nonnull String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    @Nonnull
    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(@Nonnull String sourceName) {
        this.sourceName = sourceName;
    }

    public Replication mode(@Nonnull ReplicationMode mode) {
        this.mode = mode;
        return this;
    }

    @Nonnull
    public ReplicationMode getMode() {
        return this.mode;
    }

    public void setMode(@Nonnull ReplicationMode mode) {
        this.mode = mode;
    }

    public Replication executionNodes(@Nonnull List<String> executionNodes) {
        this.executionNodes = executionNodes;
        return this;
    }

    public Replication addExecutionNodesItem(String executionNodesItem) {
        if (this.executionNodes == null) {
            this.executionNodes = new ArrayList<String>();
        }
        this.executionNodes.add(executionNodesItem);
        return this;
    }

    @Nonnull
    public List<String> getExecutionNodes() {
        return this.executionNodes;
    }

    public void setExecutionNodes(@Nonnull List<String> executionNodes) {
        this.executionNodes = executionNodes;
    }

    public Replication status(@Nullable CdcReplicationStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public CdcReplicationStatus getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable CdcReplicationStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replication replication = (Replication)o;
        return Objects.equals(this.name, replication.name) && Objects.equals(this.sinkName, replication.sinkName) && Objects.equals(this.sourceName, replication.sourceName) && Objects.equals((Object)this.mode, (Object)replication.mode) && Objects.equals(this.executionNodes, replication.executionNodes) && Objects.equals((Object)this.status, (Object)replication.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sinkName, this.sourceName, this.mode, this.executionNodes, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Replication {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sinkName: ").append(this.toIndentedString(this.sinkName)).append("\n");
        sb.append("    sourceName: ").append(this.toIndentedString(this.sourceName)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    executionNodes: ").append(this.toIndentedString(this.executionNodes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Replication is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Replication` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SINK_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sinkName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SINK_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_NAME).toString()));
        }
        ReplicationMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MODE));
        if (jsonObj.get(SERIALIZED_NAME_EXECUTION_NODES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_EXECUTION_NODES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `executionNodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXECUTION_NODES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            CdcReplicationStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
    }

    public static Replication fromJson(String jsonString) throws IOException {
        return (Replication)JSON.getGson().fromJson(jsonString, Replication.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SINK_NAME);
        openapiFields.add(SERIALIZED_NAME_SOURCE_NAME);
        openapiFields.add(SERIALIZED_NAME_MODE);
        openapiFields.add(SERIALIZED_NAME_EXECUTION_NODES);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SINK_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SOURCE_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_MODE);
        openapiRequiredFields.add(SERIALIZED_NAME_EXECUTION_NODES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Replication.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Replication.class));
            return new TypeAdapter<Replication>(){

                public void write(JsonWriter out, Replication value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Replication read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Replication.validateJsonElement(jsonElement);
                    return (Replication)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

