/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.call.cluster.unit.ClusterListUnitCall;
import org.apache.ignite.internal.cli.call.unit.ListUnitCallInput;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.repl.registry.UnitsRegistry;
import org.apache.ignite.internal.cli.core.repl.registry.impl.RegistryImplBase;
import org.apache.ignite.rest.client.model.UnitStatus;
import org.apache.ignite.rest.client.model.UnitVersionStatus;
import org.jetbrains.annotations.Nullable;

@Singleton
public class UnitsRegistryImpl
extends RegistryImplBase<Map<String, Set<String>>>
implements UnitsRegistry {
    private final ClusterListUnitCall call;

    public UnitsRegistryImpl(ClusterListUnitCall call) {
        this.call = call;
    }

    @Override
    @Nullable
    protected Map<String, Set<String>> doGetState(String url) {
        ListUnitCallInput input = ListUnitCallInput.builder().url(url).build();
        CallOutput<List<UnitStatus>> output = this.call.execute(input);
        if (!output.hasError() && !output.isEmpty()) {
            return output.body().stream().collect(Collectors.toMap(UnitStatus::getId, status -> status.getVersionToStatus().stream().map(UnitVersionStatus::getVersion).collect(Collectors.toSet())));
        }
        return null;
    }

    @Override
    public Set<String> versions(String unitId) {
        Map idToVersions = (Map)this.getResult();
        return idToVersions == null ? Set.of() : (Set)idToVersions.get(unitId);
    }

    @Override
    public Set<String> ids() {
        Map idToVersions = (Map)this.getResult();
        return idToVersions == null ? Set.of() : idToVersions.keySet();
    }
}

