/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogSystemViewDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class SystemViewDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSystemViewDescriptor> {
        SystemViewDescriptorSerializerV2() {
        }

        @Override
        public CatalogSystemViewDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            int schemaId = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            List<CatalogTableColumnDescriptor> columns = input.readEntryList(CatalogTableColumnDescriptor.class);
            byte sysViewTypeId = input.readByte();
            CatalogSystemViewDescriptor.SystemViewType sysViewType = CatalogSystemViewDescriptor.SystemViewType.forId(sysViewTypeId);
            return new CatalogSystemViewDescriptor(id, schemaId, name, columns, sysViewType, updateTimestamp);
        }

        @Override
        public void writeTo(CatalogSystemViewDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeVarInt(descriptor.schemaId());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeEntryList(descriptor.columns());
            output.writeByte(descriptor.systemViewType().id());
        }
    }
}

