/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataInput;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataOutput;

public class CatalogHashIndexDescriptorSerializers {

    @CatalogSerializer(version=3, since="3.2.0")
    static class HashIndexDescriptorSerializerV3
    implements CatalogObjectSerializer<CatalogHashIndexDescriptor> {
        HashIndexDescriptorSerializerV3() {
        }

        @Override
        public CatalogHashIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            int size = input.readVarIntAsInt();
            int[] columnIds = input.readIntArray(size);
            return new CatalogHashIndexDescriptor(id, name, tableId, unique, status, null, IntList.of((int[])columnIds), updateTimestamp, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogHashIndexDescriptor value, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(value.id());
            output.writeUTF(value.name());
            output.writeVarInt(value.updateTimestamp().longValue());
            output.writeVarInt(value.tableId());
            output.writeBoolean(value.unique());
            output.writeByte(value.status().id());
            output.writeBoolean(value.isCreatedWithTable());
            output.writeVarInt(value.columnIds().size());
            output.writeIntArray(value.columnIds().toIntArray());
        }
    }

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class HashIndexDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogHashIndexDescriptor> {
        HashIndexDescriptorSerializerV2() {
        }

        @Override
        public CatalogHashIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            List columns = input.readObjectCollection(IgniteUnsafeDataInput::readUTF, ArrayList::new);
            return new CatalogHashIndexDescriptor(id, name, tableId, unique, status, columns, null, updateTimestamp, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogHashIndexDescriptor value, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(value.id());
            output.writeUTF(value.name());
            output.writeVarInt(value.updateTimestamp().longValue());
            output.writeVarInt(value.tableId());
            output.writeBoolean(value.unique());
            output.writeByte(value.status().id());
            output.writeBoolean(value.isCreatedWithTable());
            output.writeObjectCollection(IgniteUnsafeDataOutput::writeUTF, value.columns());
        }
    }
}

