/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.Objects;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogNotFoundException;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public abstract class AbstractTableCommand
implements CatalogCommand {
    private static final IgniteLogger LOG = Loggers.forClass(AbstractTableCommand.class);
    protected final String schemaName;
    protected final String tableName;
    protected final boolean ifTableExists;

    AbstractTableCommand(String schemaName, String tableName, boolean ifTableExists, boolean validateSystemSchemas) throws CatalogValidationException {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.ifTableExists = ifTableExists;
        this.validate(validateSystemSchemas);
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tableName;
    }

    public boolean ifTableExists() {
        return this.ifTableExists;
    }

    private void validate(boolean validateSystemSchemas) {
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.tableName, "Name of the table");
        if (validateSystemSchemas) {
            CatalogParamsValidationUtils.ensureNonSystemSchemaUsed(this.schemaName);
        }
    }

    static void ensurePrimaryZoneNotUsedAsSecondary(CatalogService catalogService, Catalog eventCatalog, CatalogZoneDescriptor zone) {
        int latestVersion;
        int earliestVersion = catalogService.earliestCatalogVersion();
        for (int catalogVersion = latestVersion = eventCatalog.version(); catalogVersion >= earliestVersion; --catalogVersion) {
            AbstractTableCommand.ensurePrimaryZoneNotUsedAsSecondaryForCatalog(catalogService, catalogVersion, zone);
        }
    }

    private static void ensurePrimaryZoneNotUsedAsSecondaryForCatalog(CatalogService catalogService, int catalogVersion, CatalogZoneDescriptor zone) {
        try {
            Catalog catalog = catalogService.catalog(catalogVersion);
            boolean zoneUsedAsSecondary = catalog.tables().stream().anyMatch(table -> Objects.equals(table.secondaryZoneId(), zone.id()));
            if (zoneUsedAsSecondary) {
                throw new CatalogValidationException("Zone '{}' can't be used as a primary one as it already been assigned as secondary for one of the existing tables.", zone.name());
            }
        }
        catch (CatalogNotFoundException e) {
            LOG.debug("Missing catalog for version '{}'", new Object[]{catalogVersion});
        }
    }

    static void ensureSecondaryZoneNotUsedAsPrimary(CatalogService catalogService, Catalog eventCatalog, CatalogZoneDescriptor zone) {
        int latestVersion;
        int earliestVersion = catalogService.earliestCatalogVersion();
        for (int catalogVersion = latestVersion = eventCatalog.version(); catalogVersion >= earliestVersion; --catalogVersion) {
            AbstractTableCommand.ensureSecondaryZoneNotUsedAsPrimaryForCatalog(catalogService, catalogVersion, zone);
        }
    }

    private static void ensureSecondaryZoneNotUsedAsPrimaryForCatalog(CatalogService catalogService, int catalogVersion, CatalogZoneDescriptor zone) {
        try {
            boolean zoneUsedAsPrimary;
            Catalog catalog = catalogService.catalog(catalogVersion);
            boolean bl = zoneUsedAsPrimary = !catalog.tables(zone.id()).isEmpty();
            if (zoneUsedAsPrimary) {
                throw new CatalogValidationException("Zone '{}' can't be used as a secondary one as it already been assigned as primary for one of the existing tables.", zone.name());
            }
        }
        catch (CatalogNotFoundException e) {
            LOG.debug("Missing catalog for version '{}'", new Object[]{catalogVersion});
        }
    }

    static void ensureSecondaryZoneHasInfiniteAutoAdjust(CatalogZoneDescriptor zone) {
        if (zone.dataNodesAutoAdjustScaleUp() != Integer.MAX_VALUE || zone.dataNodesAutoAdjustScaleDown() != Integer.MAX_VALUE) {
            throw new CatalogValidationException("Zone '{}' should have scale up and scale down parameter set to {}.", zone.name(), Integer.MAX_VALUE);
        }
    }
}

