/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStatisticsDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.util.ArrayUtils;

public class NewStatisticsEntry
implements UpdateEntry {
    private final CatalogStatisticsDescriptor descriptor;

    public NewStatisticsEntry(CatalogStatisticsDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogStatisticsDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_STATISTICS.id();
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.descriptor.tableId());
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        this.descriptor.updateTimestamp(timestamp);
        List<CatalogSchemaDescriptor> schemas = CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), schema.sequences(), schema.policies(), schema.maps(), (CatalogStatisticsDescriptor[])ArrayUtils.concat((Object[])schema.statistics(), (Object[])new CatalogStatisticsDescriptor[]{this.descriptor}), timestamp), catalog.schemas());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), schemas, CatalogUtils.defaultZoneIdOpt(catalog));
    }
}

