/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropSecondaryZoneEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractUpdateTableEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;

public class DropSecondaryZoneEntry
extends AbstractUpdateTableEntry
implements Fireable {
    private final int tableId;

    public DropSecondaryZoneEntry(int tableId) {
        this.tableId = tableId;
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        return table.copyBuilder().secondaryZoneId(null).secondaryStorageProfile(null).secondaryStorageState(CatalogSecondaryStorageState.NOT_AVAILABLE);
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropSecondaryZoneEventParameters(causalityToken, catalogVersion, this.tableId);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_SECONDARY_ZONE.id();
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

