/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.AlterColumnEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class AlterColumnEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class AlterColumnEntrySerializerV2
    implements CatalogObjectSerializer<AlterColumnEntry> {
        AlterColumnEntrySerializerV2() {
        }

        @Override
        public AlterColumnEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableColumnDescriptor descriptor = input.readEntry(CatalogTableColumnDescriptor.class);
            int tableId = input.readVarIntAsInt();
            return new AlterColumnEntry(tableId, descriptor);
        }

        @Override
        public void writeTo(AlterColumnEntry value, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(value.descriptor());
            output.writeVarInt(value.tableId());
        }
    }
}

