/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.S;

abstract class AbstractChangeIndexStatusEntry
implements UpdateEntry {
    protected final int indexId;
    private final CatalogIndexStatus newStatus;

    AbstractChangeIndexStatusEntry(int indexId, CatalogIndexStatus newStatus) {
        this.indexId = indexId;
        this.newStatus = newStatus;
    }

    @Override
    public final Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSchemaDescriptor schema = AbstractChangeIndexStatusEntry.schemaByIndexId(catalog, this.indexId);
        CatalogIndexDescriptor newIndexDescriptor = this.updateIndexStatus(catalog, timestamp, this.newStatus);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(CatalogUtils.replaceIndex(schema, newIndexDescriptor), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    static CatalogSchemaDescriptor schemaByIndexId(Catalog catalog, int indexId) {
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, indexId);
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, index.tableId());
        return CatalogUtils.schemaOrThrow(catalog, table.schemaId());
    }

    private CatalogIndexDescriptor updateIndexStatus(Catalog catalog, HybridTimestamp timestamp, CatalogIndexStatus newStatus) {
        CatalogIndexDescriptor updateIndexDescriptor;
        CatalogIndexDescriptor source = CatalogUtils.indexOrThrow(catalog, this.indexId);
        if (source instanceof CatalogHashIndexDescriptor) {
            updateIndexDescriptor = AbstractChangeIndexStatusEntry.updateHashIndexStatus((CatalogHashIndexDescriptor)source, newStatus);
        } else if (source instanceof CatalogSortedIndexDescriptor) {
            updateIndexDescriptor = AbstractChangeIndexStatusEntry.updateSortedIndexStatus((CatalogSortedIndexDescriptor)source, newStatus);
        } else {
            throw new CatalogValidationException("Unsupported index type '{}' {}", source.id(), source);
        }
        updateIndexDescriptor.updateTimestamp(timestamp);
        return updateIndexDescriptor;
    }

    private static CatalogIndexDescriptor updateHashIndexStatus(CatalogHashIndexDescriptor index, CatalogIndexStatus newStatus) {
        return new CatalogHashIndexDescriptor(index.id(), index.name(), index.tableId(), index.unique(), newStatus, index.columnIds(), index.isCreatedWithTable());
    }

    private static CatalogIndexDescriptor updateSortedIndexStatus(CatalogSortedIndexDescriptor index, CatalogIndexStatus newStatus) {
        return new CatalogSortedIndexDescriptor(index.id(), index.name(), index.tableId(), index.unique(), newStatus, index.columns(), index.isCreatedWithTable());
    }

    public String toString() {
        return S.toString(AbstractChangeIndexStatusEntry.class, (Object)this);
    }
}

