/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.catalog.descriptors.CatalogStatisticsDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogStatisticsDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.16")
    static class CatalogStatisticsDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogStatisticsDescriptor> {
        CatalogStatisticsDescriptorSerializerV2() {
        }

        @Override
        public CatalogStatisticsDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            int tableId = input.readVarIntAsInt();
            boolean autoRefresh = input.readBoolean();
            boolean preferFullScan = input.readBoolean();
            int size = input.readVarIntAsInt();
            HashSet<IntSet> columnGroups = new HashSet<IntSet>(size);
            for (int i = 0; i < size; ++i) {
                int columnsSize = input.readVarIntAsInt();
                int[] columns = input.readIntArray(columnsSize);
                columnGroups.add(IntSet.of((int[])columns));
            }
            return new CatalogStatisticsDescriptor(id, name, tableId, autoRefresh, preferFullScan, Set.copyOf(columnGroups), updateTimestamp);
        }

        @Override
        public void writeTo(CatalogStatisticsDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.tableId());
            output.writeBoolean(descriptor.autoRefresh());
            output.writeBoolean(descriptor.preferFullScan());
            output.writeVarInt(descriptor.columnGroups().size());
            for (IntSet columns : descriptor.columnGroups()) {
                output.writeVarInt(columns.size());
                output.writeIntArray(columns.toIntArray());
            }
        }
    }
}

