/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogMapDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.8")
    static class MapDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogMapDescriptor> {
        MapDescriptorSerializerV2() {
        }

        @Override
        public CatalogMapDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            int id = input.readVarIntAsInt();
            int tableId = input.readVarIntAsInt();
            int schemaId = input.readVarIntAsInt();
            String name = input.readUTF();
            return new CatalogMapDescriptor(updateTimestamp, id, tableId, schemaId, name);
        }

        @Override
        public void writeTo(CatalogMapDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.id());
            output.writeVarInt(descriptor.tableId());
            output.writeVarInt(descriptor.schemaId());
            output.writeUTF(descriptor.name());
        }
    }
}

