/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractTablePolicyCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropTablePolicyCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite.internal.catalog.storage.DropTablePolicyEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;

public class DropTablePolicyCommand
extends AbstractTablePolicyCommand {
    private final boolean ifExists;

    public static DropTablePolicyCommandBuilder builder() {
        return new Builder();
    }

    private DropTablePolicyCommand(String schemaName, String policyName, boolean ifExists) throws CatalogValidationException {
        super(schemaName, policyName);
        this.ifExists = ifExists;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTablePolicyDescriptor policy = schema.policy(this.policyName);
        if (policy == null) {
            if (this.ifExists) {
                return List.of();
            }
            throw new CatalogValidationException("Table policy with name '{}.{}' not found.", schema.name(), this.policyName);
        }
        assert (catalog.table(policy.tableId()) != null) : IgniteStringFormatter.format((String)"Policy refers to non existing table [catalogVersion={}, policyId={}, tableId={}].", (Object[])new Object[]{catalog.version(), policy.id(), policy.tableId()});
        return List.of(new DropTablePolicyEntry(policy.id()));
    }

    private static class Builder
    implements DropTablePolicyCommandBuilder {
        private String schemaName;
        private String policyName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        @Override
        public DropTablePolicyCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropTablePolicyCommand(this.schemaName, this.policyName, this.ifExists);
        }
    }
}

