/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropSchemaCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.DropSchemaEntry;
import org.apache.ignite.internal.catalog.storage.DropSequenceEntry;
import org.apache.ignite.internal.catalog.storage.DropTableEntry;
import org.apache.ignite.internal.catalog.storage.DropTablePolicyEntry;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class DropSchemaCommand
implements CatalogCommand {
    private final String schemaName;
    private final boolean cascade;
    private final boolean ifExists;

    public static DropSchemaCommandBuilder builder() {
        return new Builder();
    }

    private DropSchemaCommand(String schemaName, boolean cascade, boolean ifExists) throws CatalogValidationException {
        CatalogParamsValidationUtils.validateIdentifier(schemaName, "Name of the schema");
        this.schemaName = schemaName;
        this.cascade = cascade;
        this.ifExists = ifExists;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        CatalogSchemaDescriptor schema;
        Catalog catalog = updateContext.catalog();
        if (CatalogUtils.isSystemSchema(this.schemaName)) {
            throw new CatalogValidationException("System schema can't be dropped [name={}].", this.schemaName);
        }
        if (this.ifExists) {
            schema = catalog.schema(this.schemaName);
            if (schema == null) {
                return List.of();
            }
        } else {
            schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        }
        if (!this.cascade && !schema.isEmpty()) {
            throw new CatalogValidationException("Schema '{}' is not empty. Use CASCADE to drop it anyway.", this.schemaName);
        }
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Arrays.stream(schema.policies()).forEach(policy -> updateEntries.add(new DropTablePolicyEntry(policy.id())));
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, "SYSTEM");
        Arrays.stream(schema.sequences()).forEach(sequence -> {
            Arrays.stream(systemSchema.indexes()).filter(index -> index.tableId() == sequence.tableId()).forEach(index -> updateEntries.add(new RemoveIndexEntry(index.id())));
            updateEntries.add(new DropTableEntry(sequence.tableId()));
            updateEntries.add(new DropSequenceEntry(sequence.id()));
        });
        Arrays.stream(schema.indexes()).forEach(index -> updateEntries.add(new RemoveIndexEntry(index.id())));
        for (CatalogTableDescriptor tbl : schema.tables()) {
            updateEntries.add(new DropTableEntry(tbl.id()));
        }
        updateEntries.add(new DropSchemaEntry(schema.id()));
        return updateEntries;
    }

    private static class Builder
    implements DropSchemaCommandBuilder {
        private String schemaName;
        private boolean cascade;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropSchemaCommandBuilder name(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public DropSchemaCommandBuilder cascade(boolean cascade) {
            this.cascade = cascade;
            return this;
        }

        @Override
        public DropSchemaCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropSchemaCommand(this.schemaName, this.cascade, this.ifExists);
        }
    }
}

