/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractIndexCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropIndexCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.DropIndexEntry;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;

public class DropIndexCommand
extends AbstractIndexCommand {
    private final boolean ifExists;

    public static DropIndexCommandBuilder builder() {
        return new Builder();
    }

    private DropIndexCommand(String schemaName, String indexName, boolean ifExists) throws CatalogValidationException {
        super(schemaName, indexName);
        this.ifExists = ifExists;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifExists);
        if (schema == null) {
            return List.of();
        }
        CatalogIndexDescriptor index = CatalogUtils.index(schema, this.indexName, !this.ifExists);
        if (index == null) {
            return List.of();
        }
        CatalogTableDescriptor table = catalog.table(index.tableId());
        assert (table != null) : IgniteStringFormatter.format((String)"Index refers to non existing table [catalogVersion={}, indexId={}, tableId={}].", (Object[])new Object[]{catalog.version(), index.id(), index.tableId()});
        if (table.primaryKeyIndexId() == index.id()) {
            throw new CatalogValidationException("Dropping primary key index is not allowed.");
        }
        Integer expireColumnIndexId = table.expireColumnIndexId();
        if (expireColumnIndexId != null && expireColumnIndexId.intValue() == index.id()) {
            throw new CatalogValidationException("Dropping index on expire column is not allowed");
        }
        Integer archiveColumnIndexId = table.archiveColumnIndexId();
        if (archiveColumnIndexId != null && archiveColumnIndexId.intValue() == index.id()) {
            throw new CatalogValidationException("Dropping index on archive column is not allowed");
        }
        return List.of(DropIndexCommand.updateEntryForIndex(index));
    }

    static UpdateEntry updateEntryForIndex(CatalogIndexDescriptor index) {
        switch (index.status()) {
            case REGISTERED: 
            case BUILDING: {
                return new RemoveIndexEntry(index.id());
            }
            case AVAILABLE: {
                return new DropIndexEntry(index.id());
            }
        }
        throw new IllegalStateException("Unknown index status: " + index.status());
    }

    private static class Builder
    implements DropIndexCommandBuilder {
        private String schemaName;
        private String indexName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Override
        public DropIndexCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropIndexCommand(this.schemaName, this.indexName, this.ifExists);
        }
    }
}

