/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.DefaultPartitionCountProvider;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.storage.NewZoneEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CreateZoneCommand
extends AbstractZoneCommand {
    private final boolean ifNotExists;
    @Nullable
    private final Integer partitions;
    @Nullable
    private final Integer replicas;
    @Nullable
    private final Integer quorumSize;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleUp;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleDown;
    @Nullable
    private final String filter;
    private final List<StorageProfileParams> storageProfileParams;
    @Nullable
    private final ConsistencyMode consistencyMode;

    public static CreateZoneCommandBuilder builder(DefaultPartitionCountProvider defaultPartitionCountProvider) {
        return new Builder(defaultPartitionCountProvider);
    }

    @TestOnly
    public static CreateZoneCommandBuilder builder() {
        return CreateZoneCommand.builder((f, sp, r) -> 25);
    }

    private CreateZoneCommand(String zoneName, boolean ifNotExists, @Nullable Integer partitions, @Nullable Integer replicas, @Nullable Integer quorumSize, @Nullable Integer dataNodesAutoAdjustScaleUp, @Nullable Integer dataNodesAutoAdjustScaleDown, @Nullable String filter, List<StorageProfileParams> storageProfileParams, @Nullable ConsistencyMode consistencyMode) throws CatalogValidationException {
        super(zoneName);
        this.ifNotExists = ifNotExists;
        this.partitions = partitions;
        this.replicas = replicas;
        this.quorumSize = quorumSize;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfileParams = storageProfileParams;
        this.consistencyMode = consistencyMode;
        this.validate();
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        if (catalog.zone(this.zoneName) != null) {
            if (this.ifNotExists) {
                return List.of();
            }
            throw CatalogUtils.duplicateDistributionZoneNameCatalogValidationException(this.zoneName);
        }
        CatalogZoneDescriptor zoneDesc = this.descriptor(catalog.objectIdGenState());
        return List.of(new NewZoneEntry(zoneDesc), new ObjectIdGenUpdateEntry(1));
    }

    private CatalogZoneDescriptor descriptor(int objectId) {
        int replicas = Objects.requireNonNullElse(this.replicas, 1);
        return new CatalogZoneDescriptor(objectId, this.zoneName, Objects.requireNonNull(this.partitions), replicas, Objects.requireNonNullElse(this.quorumSize, CatalogUtils.defaultQuorumSize(replicas)), Objects.requireNonNullElse(this.dataNodesAutoAdjustScaleUp, 0), Objects.requireNonNullElse(this.dataNodesAutoAdjustScaleDown, Integer.MAX_VALUE), Objects.requireNonNullElse(this.filter, "$..*"), CatalogUtils.fromParams(this.storageProfileParams), Objects.requireNonNullElse(this.consistencyMode, ConsistencyMode.STRONG_CONSISTENCY));
    }

    private void validate() {
        CatalogParamsValidationUtils.validateField(this.partitions, 1, 65000, "Invalid number of partitions");
        CatalogParamsValidationUtils.validateField(this.replicas, 1, null, "Invalid number of replicas");
        CatalogParamsValidationUtils.validateField(this.quorumSize, 1, null, "Invalid quorum size");
        int replicas = Objects.requireNonNullElse(this.replicas, 1);
        int quorumSize = Objects.requireNonNullElse(this.quorumSize, CatalogUtils.defaultQuorumSize(replicas));
        this.validateReplicasAndQuorumCompatibility(replicas, quorumSize);
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleUp, 0, null, "Invalid data nodes auto adjust scale up");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleDown, 0, null, "Invalid data nodes auto adjust scale down");
        CatalogParamsValidationUtils.validateZoneFilter(this.filter);
        CatalogParamsValidationUtils.validateConsistencyMode(this.consistencyMode);
        CatalogParamsValidationUtils.validateStorageProfiles(this.storageProfileParams);
    }

    private void validateReplicasAndQuorumCompatibility(int replicas, int quorumSize) {
        int minQuorum = Math.min(replicas, 2);
        int maxQuorum = Math.max(minQuorum, (int)Math.round((double)replicas / 2.0));
        if (quorumSize < minQuorum || quorumSize > maxQuorum) {
            throw new CatalogValidationException("{}: [quorum size={}, min={}, max={}, replicas count={}].", this.getErrPrefix(), quorumSize, minQuorum, maxQuorum, replicas);
        }
    }

    private String getErrPrefix() {
        if (this.quorumSize != null) {
            if (this.replicas != null) {
                return "Specified quorum size doesn't fit into the specified replicas count";
            }
            return "Specified quorum size doesn't fit into the default replicas count";
        }
        if (this.replicas != null) {
            return "Current quorum size doesn't fit into the specified replicas count";
        }
        return "Default quorum size doesn't fit into the default replicas count";
    }

    private static class Builder
    implements CreateZoneCommandBuilder {
        private final DefaultPartitionCountProvider defaultPartitionCountProvider;
        private String zoneName;
        private boolean ifNotExists;
        @Nullable
        private Integer partitions;
        @Nullable
        private Integer replicas;
        @Nullable
        private Integer quorumSize;
        @Nullable
        private Integer dataNodesAutoAdjustScaleUp;
        @Nullable
        private Integer dataNodesAutoAdjustScaleDown;
        @Nullable
        private String filter;
        @Nullable
        private ConsistencyMode consistencyMode;
        private List<StorageProfileParams> storageProfileParams;

        private Builder(DefaultPartitionCountProvider defaultPartitionCountProvider) {
            this.defaultPartitionCountProvider = defaultPartitionCountProvider;
        }

        @Override
        public CreateZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder partitions(Integer partitions) {
            this.partitions = partitions;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder quorumSize(Integer quorumSize) {
            this.quorumSize = quorumSize;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder dataNodesAutoAdjustScaleUp(Integer adjust) {
            this.dataNodesAutoAdjustScaleUp = adjust;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder dataNodesAutoAdjustScaleDown(Integer adjust) {
            this.dataNodesAutoAdjustScaleDown = adjust;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder storageProfilesParams(List<StorageProfileParams> params) {
            this.storageProfileParams = params;
            return this;
        }

        private int defaultPartitionCount() {
            List<String> storageProfiles = this.storageProfileParams == null ? null : this.storageProfileParams.stream().map(StorageProfileParams::storageProfile).collect(Collectors.toList());
            return this.defaultPartitionCountProvider.calculate(this.filter, storageProfiles, this.replicas);
        }

        @Override
        public CreateZoneCommandBuilder consistencyModeParams(@Nullable ConsistencyMode params) {
            this.consistencyMode = params;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateZoneCommand(this.zoneName, this.ifNotExists, Objects.requireNonNullElse(this.partitions, this.defaultPartitionCount()), this.replicas, this.quorumSize, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown, this.filter, this.storageProfileParams, this.consistencyMode);
        }
    }
}

