/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.ignite.cache.CacheWriteMode;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.secondary.SecondaryDataStorages;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.NewTableEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CreateTableCommand
extends AbstractTableCommand {
    private final TablePrimaryKey primaryKey;
    @Nullable
    private final List<String> colocationColumns;
    private final List<ColumnParams> columns;
    private final String zoneName;
    @Nullable
    private final String storageProfile;
    private final double staleRowsFraction;
    private final long minStaleRowsCount;
    @Nullable
    private final String secondaryZoneName;
    @Nullable
    private final String secondaryStorageProfile;
    @Nullable
    private final String expireColumn;
    @Nullable
    private final String archiveColumn;
    private final Predicate<String> secondaryEngineResolver;

    public static CreateTableCommandBuilder builder() {
        return new Builder();
    }

    private CreateTableCommand(String tableName, String schemaName, boolean ifNotExists, TablePrimaryKey primaryKey, @Nullable List<String> colocationColumns, List<ColumnParams> columns, @Nullable String zoneName, @Nullable String storageProfile, @Nullable String secondaryZoneName, @Nullable String secondaryStorageProfile, @Nullable String expireColumn, @Nullable String archiveColumn, Predicate<String> secondaryEngineResolver, boolean validateSystemSchemas, double staleRowsFraction, long minStaleRowsCount) throws CatalogValidationException {
        super(schemaName, tableName, ifNotExists, validateSystemSchemas);
        this.primaryKey = primaryKey;
        this.colocationColumns = CollectionUtils.copyOrNull(colocationColumns);
        this.columns = CollectionUtils.copyOrNull(columns);
        this.zoneName = zoneName;
        this.storageProfile = storageProfile;
        this.secondaryZoneName = secondaryZoneName;
        this.secondaryStorageProfile = secondaryStorageProfile;
        this.expireColumn = expireColumn;
        this.archiveColumn = archiveColumn;
        this.secondaryEngineResolver = secondaryEngineResolver;
        this.staleRowsFraction = staleRowsFraction;
        this.minStaleRowsCount = minStaleRowsCount;
        this.validate();
    }

    @Nullable
    public String expireColumn() {
        return this.expireColumn;
    }

    @Nullable
    public String archiveColumn() {
        return this.archiveColumn;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        CatalogZoneDescriptor zone;
        Catalog catalog = updateContext.catalog();
        CatalogService catalogService = updateContext.catalogService();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogTableDescriptor existedDescriptor = schema.table(this.tableName);
        if (this.ifTableExists && existedDescriptor != null && !existedDescriptor.cache()) {
            return List.of();
        }
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.tableName);
        int id = catalog.objectIdGenState();
        int tableId = id++;
        int pkIndexId = id++;
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>(5);
        CatalogZoneDescriptor catalogZoneDescriptor = zone = CatalogUtils.shouldCreateNewDefaultZone(catalog, this.zoneName) ? CatalogUtils.createDefaultZoneDescriptor(catalog, id++, updateEntries) : CatalogUtils.zoneByNameOrDefaultOrThrow(catalog, this.zoneName);
        assert (zone != null);
        String storageProfile = this.storageProfile != null ? this.storageProfile : zone.storageProfiles().defaultProfile().storageProfile();
        CatalogParamsValidationUtils.ensureZoneContainsTablesStorageProfile(zone, storageProfile);
        CreateTableCommand.ensurePrimaryZoneNotUsedAsSecondary(catalogService, catalog, zone);
        if (this.secondaryEngineResolver.test(storageProfile)) {
            throw new CatalogValidationException("Provided storage profile must not be for a secondary storage engine: {}", storageProfile);
        }
        CatalogZoneDescriptor secondaryZone = null;
        if (this.secondaryZoneName != null) {
            if (this.secondaryZoneName.equals(zone.name())) {
                throw new CatalogValidationException("Primary and secondary zone name should not point into the same zone");
            }
            secondaryZone = CatalogUtils.zoneOrThrow(catalog, this.secondaryZoneName);
            if (!SecondaryDataStorages.hasSecondaryStorageProfile(this.secondaryStorageProfile)) {
                throw new CatalogValidationException("SECONDARY ZONE should be set together with SECONDARY STORAGE PROFILE.");
            }
            CatalogParamsValidationUtils.ensureZoneContainsTablesStorageProfile(secondaryZone, this.secondaryStorageProfile);
            this.secondaryEngineResolver.test(this.secondaryStorageProfile);
            if (zone.partitions() != secondaryZone.partitions()) {
                throw new CatalogValidationException("Primary and secondary zone should have the same number of partitions.");
            }
            CreateTableCommand.ensureSecondaryZoneNotUsedAsPrimary(catalogService, catalog, secondaryZone);
            CreateTableCommand.ensureSecondaryZoneHasInfiniteAutoAdjust(secondaryZone);
        } else if (this.secondaryStorageProfile != null) {
            throw new CatalogValidationException("SECONDARY STORAGE PROFILE should be set together with SECONDARY ZONE.");
        }
        Integer expireColumnIndexId = null;
        if (this.expireColumn != null) {
            expireColumnIndexId = id++;
        }
        Integer archiveColumnIndexId = null;
        if (this.archiveColumn != null) {
            archiveColumnIndexId = id++;
        }
        ArrayList<CatalogTableColumnDescriptor> tableColumns = new ArrayList<CatalogTableColumnDescriptor>(this.columns.size());
        for (ColumnParams columnParams : this.columns) {
            tableColumns.add(CatalogUtils.fromParams(catalog, columnParams));
        }
        CatalogTableSchemaVersions versions = new CatalogTableSchemaVersions(new CatalogTableSchemaVersions.TableVersion(tableColumns));
        Object2IntOpenHashMap columnIdByName = new Object2IntOpenHashMap();
        for (CatalogTableColumnDescriptor columnDescriptor : versions.latestVersionColumns()) {
            columnIdByName.put((Object)columnDescriptor.name(), columnDescriptor.id());
        }
        IntList pkColumns = CreateTableCommand.convertNamesToIds(this.primaryKey.columns(), (Object2IntMap<String>)columnIdByName);
        IntList colocationColumns = CreateTableCommand.convertNamesToIds(this.colocationColumns, (Object2IntMap<String>)columnIdByName);
        CatalogTableDescriptor table = CatalogTableDescriptor.builder().id(tableId).schemaId(schema.id()).primaryKeyIndexId(pkIndexId).name(this.tableName).zoneId(zone.id()).secondaryZoneId(secondaryZone != null ? Integer.valueOf(secondaryZone.id()) : null).schemaVersions(versions).primaryKeyColumns(pkColumns).colocationColumns(colocationColumns).storageProfile(storageProfile).secondaryStorageProfile(this.secondaryStorageProfile).expireColumn(CreateTableCommand.convertNameToId(this.expireColumn, (Object2IntMap<String>)columnIdByName)).expireColumnIndexId(expireColumnIndexId).cacheWriteMode(CacheWriteMode.SYNC).archiveColumn(CreateTableCommand.convertNameToId(this.archiveColumn, (Object2IntMap<String>)columnIdByName)).archiveColumnIndexId(archiveColumnIndexId).secondaryStorageState(secondaryZone != null ? CatalogSecondaryStorageState.AVAILABLE : CatalogSecondaryStorageState.NOT_AVAILABLE).minStaleRowsCount(this.minStaleRowsCount).staleRowsFraction(this.staleRowsFraction).build();
        String indexName = this.primaryKey.name();
        if (indexName == null) {
            indexName = CatalogUtils.pkIndexName(this.tableName);
        }
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        CatalogIndexDescriptor pkIndex = this.createPkIndexDescriptor(indexName, pkIndexId, table);
        updateEntries.add(new NewTableEntry(table));
        updateEntries.add(new NewIndexEntry(pkIndex));
        updateEntries.add(new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState()));
        if (this.expireColumn != null) {
            String expireColumnIndexName = CatalogUtils.generateNameForExpireColumnIndex(schema, this.tableName);
            CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, expireColumnIndexName);
            CatalogSortedIndexDescriptor expireColIndex = new CatalogSortedIndexDescriptor(expireColumnIndexId, expireColumnIndexName, tableId, false, CatalogIndexStatus.AVAILABLE, List.of(new CatalogIndexColumnDescriptor(table.column(this.expireColumn).id(), CatalogColumnCollation.ASC_NULLS_LAST)), true);
            updateEntries.add(new NewIndexEntry(expireColIndex));
        }
        if (this.archiveColumn != null) {
            String archiveColumnIndexName = CatalogUtils.generateNameForArchiveColumnIndex(schema, this.tableName);
            CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, archiveColumnIndexName);
            CatalogSortedIndexDescriptor archiveColIndex = new CatalogSortedIndexDescriptor(archiveColumnIndexId, archiveColumnIndexName, tableId, false, CatalogIndexStatus.AVAILABLE, List.of(new CatalogIndexColumnDescriptor(table.column(this.archiveColumn).id(), CatalogColumnCollation.ASC_NULLS_LAST)), true);
            updateEntries.add(new NewIndexEntry(archiveColIndex));
        }
        return updateEntries;
    }

    public List<ColumnParams> columns() {
        return this.columns;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    static IntList convertNamesToIds(@Nullable List<String> names, Object2IntMap<String> columnIdByName) {
        if (names == null) {
            return null;
        }
        IntArrayList ids = new IntArrayList(names.size());
        for (String name : names) {
            ids.add(columnIdByName.getInt((Object)name));
        }
        return ids;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    static Integer convertNameToId(@Nullable String name, Object2IntMap<String> columnIdByName) {
        if (name == null) {
            return null;
        }
        return columnIdByName.getInt((Object)name);
    }

    private void validate() {
        if (CollectionUtils.nullOrEmpty(this.columns)) {
            throw new CatalogValidationException("Table should have at least one column.");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnParams columnParams : this.columns) {
            if (columnNames.add(columnParams.name())) continue;
            throw new CatalogValidationException("Column with name '{}' specified more than once.", columnParams.name());
        }
        if (this.primaryKey == null || CollectionUtils.nullOrEmpty(this.primaryKey.columns())) {
            throw new CatalogValidationException("Table should have primary key.");
        }
        this.primaryKey.validate(this.columns);
        for (ColumnParams columnParams : this.columns) {
            boolean partOfPk = this.primaryKey.columns().contains(columnParams.name());
            CatalogUtils.ensureTypeCanBeStored(columnParams.name(), columnParams.type());
            if (partOfPk) {
                CatalogUtils.ensureSupportedDefault(columnParams.name(), columnParams.type(), columnParams.defaultValueDefinition());
            } else {
                CatalogUtils.ensureNonFunctionalDefault(columnParams.name(), columnParams.type(), columnParams.defaultValueDefinition());
            }
            CatalogUtils.ensureSupportedDefault(columnParams);
        }
        if (CollectionUtils.nullOrEmpty(this.colocationColumns)) {
            throw new CatalogValidationException("Colocation columns could not be empty.");
        }
        HashSet<String> colocationColumnsSet = new HashSet<String>();
        for (String name : this.colocationColumns) {
            if (!this.primaryKey.columns().contains(name)) {
                throw new CatalogValidationException("Colocation column '{}' is not part of PK.", name);
            }
            if (colocationColumnsSet.add(name)) continue;
            throw new CatalogValidationException("Colocation column '{}' specified more that once", name);
        }
        if (this.expireColumn != null) {
            Optional<ColumnParams> optional = this.columns.stream().filter(c -> c.name().equals(this.expireColumn)).findAny();
            if (optional.isEmpty()) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column '{}' set as expire column doesn't exist", (Object[])new Object[]{this.expireColumn}));
            }
            if (optional.get().type() != ColumnType.TIMESTAMP) {
                throw new CatalogValidationException("Expire column must be of type TIMESTAMP WITH LOCAL TIME ZONE.");
            }
        }
        if (this.archiveColumn != null) {
            if (this.expireColumn != null) {
                throw new CatalogValidationException("Archive column can't be set together with expire column.");
            }
            if (this.secondaryZoneName == null) {
                throw new CatalogValidationException("Archive column can't be set for a table without secondary zone.");
            }
            ColumnParams columnParams = this.columns.stream().filter(c -> c.name().equals(this.archiveColumn)).findAny().orElseThrow(() -> new CatalogValidationException(IgniteStringFormatter.format((String)"Column '{}' set as archive column doesn't exist.", (Object[])new Object[]{this.archiveColumn})));
            if (columnParams.type() != ColumnType.TIMESTAMP) {
                throw new CatalogValidationException("Archive column must be of type TIMESTAMP WITH LOCAL TIME ZONE.");
            }
        }
        if (this.secondaryZoneName != null && this.secondaryZoneName.isBlank()) {
            throw new CatalogValidationException("Name of the secondary zone can't be empty or blank.");
        }
        if (!Double.isFinite(this.staleRowsFraction) || this.staleRowsFraction > 1.0 || this.staleRowsFraction < 0.0) {
            throw new CatalogValidationException("Stale rows fraction should be in range [0, 1].");
        }
        if (this.minStaleRowsCount < 0L) {
            throw new CatalogValidationException("Minimal stale rows count should be non-negative.");
        }
    }

    private CatalogIndexDescriptor createPkIndexDescriptor(String indexName, int pkIndexId, CatalogTableDescriptor table) {
        CatalogIndexDescriptor pkIndex;
        if (this.primaryKey instanceof TableSortedPrimaryKey) {
            TableSortedPrimaryKey sortedPrimaryKey = (TableSortedPrimaryKey)this.primaryKey;
            ArrayList<CatalogIndexColumnDescriptor> indexColumns = new ArrayList<CatalogIndexColumnDescriptor>(sortedPrimaryKey.columns().size());
            for (int i = 0; i < sortedPrimaryKey.columns().size(); ++i) {
                String columnName = sortedPrimaryKey.columns().get(i);
                CatalogTableColumnDescriptor column = table.column(columnName);
                assert (column != null) : columnName;
                CatalogColumnCollation collation = sortedPrimaryKey.collations().get(i);
                indexColumns.add(new CatalogIndexColumnDescriptor(column.id(), collation));
            }
            pkIndex = new CatalogSortedIndexDescriptor(pkIndexId, indexName, table.id(), true, CatalogIndexStatus.AVAILABLE, indexColumns, true);
        } else if (this.primaryKey instanceof TableHashPrimaryKey) {
            TableHashPrimaryKey hashPrimaryKey = (TableHashPrimaryKey)this.primaryKey;
            IntArrayList columnIds = new IntArrayList(hashPrimaryKey.columns().size());
            for (String columnName : hashPrimaryKey.columns()) {
                CatalogTableColumnDescriptor column = table.column(columnName);
                assert (column != null) : columnName;
                columnIds.add(column.id());
            }
            pkIndex = new CatalogHashIndexDescriptor(pkIndexId, indexName, table.id(), true, CatalogIndexStatus.AVAILABLE, (IntList)columnIds, true);
        } else {
            throw new IllegalArgumentException("Unexpected primary key type: " + this.primaryKey);
        }
        return pkIndex;
    }

    private static class Builder
    implements CreateTableCommandBuilder {
        private List<ColumnParams> columns;
        private String schemaName;
        private String tableName;
        private boolean ifNotExists;
        private TablePrimaryKey primaryKey;
        private List<String> colocationColumns;
        private String zoneName;
        private String storageProfile;
        private boolean validateSystemSchemas = true;
        private String secondaryZoneName;
        @Nullable
        private String secondaryStorageProfile;
        @Nullable
        private String expireColumn;
        @Nullable
        private String archiveColumn;
        private Predicate<String> secondaryEngineResolver = ignore -> false;
        private double staleRowsFraction = 0.2;
        private long minStaleRowsCount = 500L;

        private Builder() {
        }

        @Override
        public CreateTableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder ifTableExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateTableCommandBuilder columns(List<ColumnParams> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CreateTableCommandBuilder primaryKey(TablePrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public CreateTableCommandBuilder colocationColumns(List<String> colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        @Override
        public CreateTableCommandBuilder zone(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        @Override
        public CreateTableCommandBuilder validateSystemSchemas(boolean validateSystemSchemas) {
            this.validateSystemSchemas = validateSystemSchemas;
            return this;
        }

        @Override
        public CreateTableCommandBuilder secondaryZone(String secondaryZoneName) {
            this.secondaryZoneName = secondaryZoneName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder secondaryStorageProfile(String secondaryStorageProfile) {
            this.secondaryStorageProfile = secondaryStorageProfile;
            return this;
        }

        @Override
        public CreateTableCommandBuilder expireColumn(String expireColumn) {
            this.expireColumn = expireColumn;
            return this;
        }

        @Override
        public CreateTableCommandBuilder archiveColumn(String archiveColumn) {
            this.archiveColumn = archiveColumn;
            return this;
        }

        @Override
        public CreateTableCommandBuilder secondaryEngineResolver(Predicate<String> secondaryEngineResolver) {
            this.secondaryEngineResolver = secondaryEngineResolver;
            return this;
        }

        @Override
        public CreateTableCommandBuilder staleRowsFraction(double staleRowsFraction) {
            this.staleRowsFraction = staleRowsFraction;
            return this;
        }

        @Override
        public CreateTableCommandBuilder minStaleRowsCount(long minStaleRowsCount) {
            this.minStaleRowsCount = minStaleRowsCount;
            return this;
        }

        @Override
        public CatalogCommand build() {
            List<String> colocationColumns = this.colocationColumns != null ? this.colocationColumns : (this.primaryKey != null ? this.primaryKey.columns() : null);
            return new CreateTableCommand(this.tableName, this.schemaName, this.ifNotExists, this.primaryKey, colocationColumns, this.columns, this.zoneName, this.storageProfile, this.secondaryZoneName, this.secondaryStorageProfile, this.expireColumn, this.archiveColumn, this.secondaryEngineResolver, this.validateSystemSchemas, this.staleRowsFraction, this.minStaleRowsCount);
        }
    }
}

