/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractStatisticsCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.CreateStatisticsCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStatisticsDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.NewStatisticsEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.jetbrains.annotations.Nullable;

public class CreateStatisticsCommand
extends AbstractStatisticsCommand {
    private static final int DEFAULT_GROUP_SET_LIMIT = 100;
    private final String tableName;
    private final boolean ifNotExists;
    private final boolean autoRefresh;
    private final boolean preferFullScan;
    private final boolean addDefaultColumnGroups;
    private final Collection<Collection<String>> columnGroups;

    public static CreateStatisticsCommandBuilder builder() {
        return new Builder();
    }

    private CreateStatisticsCommand(String schemaName, String tableName, String statisticsName, boolean ifNotExists, boolean autoRefresh, boolean preferFullScan, boolean addDefaultColumnGroups, Collection<Collection<String>> columnGroups) {
        super(schemaName, statisticsName);
        this.tableName = tableName;
        this.ifNotExists = ifNotExists;
        this.autoRefresh = autoRefresh;
        this.preferFullScan = preferFullScan;
        this.addDefaultColumnGroups = addDefaultColumnGroups;
        this.columnGroups = Objects.requireNonNull(columnGroups, "columnGroups cannot be null");
        this.validate();
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.tableName, "Name of the table");
        if (!this.addDefaultColumnGroups && this.columnGroups.isEmpty()) {
            throw new CatalogValidationException("Statistics should have at least one columns group defined.");
        }
        for (Collection<String> columnGroup : this.columnGroups) {
            if (!columnGroup.isEmpty()) continue;
            throw new CatalogValidationException("Empty column groups are not allowed.");
        }
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        if (schema.statistics(this.statisticsName) != null) {
            if (this.ifNotExists) {
                return List.of();
            }
            throw new CatalogValidationException("Statistics with name '{}.{}' already exists.", schema.name(), this.statisticsName);
        }
        CatalogTableDescriptor table = CatalogUtils.tableOrCache(schema, this.tableName);
        HashSet<IntSet> newColumnGroups = new HashSet<IntSet>();
        if (this.addDefaultColumnGroups) {
            CreateStatisticsCommand.addDefaultGroupSets(catalog, table, newColumnGroups);
        }
        for (Collection<String> columnGroup : this.columnGroups) {
            IntOpenHashSet newColumnGroup = new IntOpenHashSet();
            for (String columnName : columnGroup) {
                CatalogTableColumnDescriptor column = CatalogUtils.columnOrThrow(this.schemaName, table, columnName);
                newColumnGroup.add(column.id());
            }
            newColumnGroups.add((IntSet)newColumnGroup);
        }
        return List.of(new ObjectIdGenUpdateEntry(1), new NewStatisticsEntry(new CatalogStatisticsDescriptor(catalog.objectIdGenState(), this.statisticsName, table.id(), this.autoRefresh, this.preferFullScan, newColumnGroups, CatalogManager.INITIAL_TIMESTAMP)));
    }

    private static void addDefaultGroupSets(Catalog catalog, CatalogTableDescriptor table, Set<IntSet> columnGroups) {
        assert (columnGroups.isEmpty()) : "Default groups creation should be called with empty groups collection";
        block4: for (CatalogIndexDescriptor index : catalog.indexes(table.id())) {
            if (index.status() == CatalogIndexStatus.STOPPING) continue;
            switch (index.indexType()) {
                case HASH: {
                    columnGroups.add((IntSet)new IntOpenHashSet((IntCollection)((CatalogHashIndexDescriptor)index).columnIds()));
                    break;
                }
                case SORTED: {
                    IntOpenHashSet columns = new IntOpenHashSet();
                    for (CatalogIndexColumnDescriptor column : ((CatalogSortedIndexDescriptor)index).columns()) {
                        columns.add(column.columnId());
                        columnGroups.add((IntSet)IntArraySet.of((int[])columns.toIntArray()));
                    }
                    continue block4;
                }
                default: {
                    assert (false) : "Unknown index type " + index.indexType();
                    continue block4;
                }
            }
        }
        columnGroups.add(IntSet.of((int[])table.colocationColumns().toIntArray()));
        for (CatalogTableColumnDescriptor column : table.columns()) {
            if (columnGroups.size() >= 100) break;
            columnGroups.add(IntSet.of((int)column.id()));
        }
    }

    private static class Builder
    implements CreateStatisticsCommandBuilder {
        private String schemaName;
        private String tableName;
        private String statisticsName;
        private boolean ifNotExists;
        private boolean autoRefresh;
        private boolean preferFullScan;
        private boolean addDefaultColumnGroups;
        @Nullable
        private Collection<Collection<String>> columnGroups;

        private Builder() {
        }

        @Override
        public CreateStatisticsCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder statisticsName(String statisticsName) {
            this.statisticsName = statisticsName;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder autoRefresh(boolean autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder preferFullScan(boolean preferFullScan) {
            this.preferFullScan = preferFullScan;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder addDefaultColumnGroups(boolean addDefaultColumnGroups) {
            this.addDefaultColumnGroups = addDefaultColumnGroups;
            return this;
        }

        @Override
        public CreateStatisticsCommandBuilder columnGroups(@Nullable Collection<Collection<String>> columnGroups) {
            this.columnGroups = columnGroups;
            return this;
        }

        @Override
        public CreateStatisticsCommand build() {
            return new CreateStatisticsCommand(this.schemaName, this.tableName, this.statisticsName, this.ifNotExists, this.autoRefresh, this.preferFullScan, this.addDefaultColumnGroups, this.columnGroups == null ? List.of() : this.columnGroups);
        }
    }
}

