/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.cache.CacheWriteMode;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractCacheCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateCacheCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.NewTableEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CreateCacheCommand
extends AbstractCacheCommand {
    private final TablePrimaryKey primaryKey;
    private final List<String> colocationColumns;
    private final List<ColumnParams> columns;
    private final String zoneName;
    private String storageProfile;
    @Nullable
    private final String expireColumn;
    private final Predicate<String> engineResolver;
    private final CacheWriteMode cacheWriteMode;

    public static CreateCacheCommandBuilder builder() {
        return new Builder();
    }

    private CreateCacheCommand(String cacheName, String schemaName, boolean ifNotExists, TablePrimaryKey primaryKey, List<String> colocationColumns, List<ColumnParams> columns, @Nullable String zoneName, String storageProfile, @Nullable String expireColumn, Predicate<String> engineResolver, CacheWriteMode cacheWriteMode) throws CatalogValidationException {
        super(schemaName, cacheName, ifNotExists);
        this.primaryKey = primaryKey;
        this.colocationColumns = CollectionUtils.copyOrNull(colocationColumns);
        this.columns = CollectionUtils.copyOrNull(columns);
        this.zoneName = zoneName;
        this.storageProfile = storageProfile;
        this.expireColumn = expireColumn;
        this.engineResolver = engineResolver;
        this.cacheWriteMode = cacheWriteMode;
        this.validate();
    }

    @Nullable
    public String expireColumn() {
        return this.expireColumn;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        CatalogZoneDescriptor zone;
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogTableDescriptor existedDescriptor = schema.table(this.cacheName);
        if (this.ifTableExists && existedDescriptor != null && existedDescriptor.cache()) {
            return List.of();
        }
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.cacheName);
        int id = catalog.objectIdGenState();
        int cacheId = id++;
        int pkIndexId = id++;
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>(5);
        CatalogZoneDescriptor catalogZoneDescriptor = zone = CatalogUtils.shouldCreateNewDefaultZone(catalog, this.zoneName) ? CatalogUtils.createDefaultZoneDescriptor(catalog, id++, updateEntries) : CatalogUtils.zoneByNameOrDefaultOrThrow(catalog, this.zoneName);
        assert (zone != null);
        if (this.storageProfile == null) {
            this.storageProfile = zone.storageProfiles().defaultProfile().storageProfile();
        }
        CatalogParamsValidationUtils.ensureZoneContainsTablesStorageProfile(zone, this.storageProfile);
        if (!this.engineResolver.test(this.storageProfile)) {
            throw new CatalogValidationException("Caches support only volatile engine types.");
        }
        Integer expireColumnIndexId = null;
        if (this.expireColumn != null) {
            expireColumnIndexId = id++;
        }
        List<CatalogTableColumnDescriptor> cacheColumns = this.columns.stream().map(c -> CatalogUtils.fromParams(catalog, c)).collect(Collectors.toList());
        CatalogTableSchemaVersions versions = new CatalogTableSchemaVersions(new CatalogTableSchemaVersions.TableVersion(cacheColumns));
        Object2IntOpenHashMap columnIdByName = new Object2IntOpenHashMap();
        for (CatalogTableColumnDescriptor columnDescriptor : versions.latestVersionColumns()) {
            columnIdByName.put((Object)columnDescriptor.name(), columnDescriptor.id());
        }
        IntList pkColumns = CreateTableCommand.convertNamesToIds(this.primaryKey.columns(), (Object2IntMap<String>)columnIdByName);
        IntList colocationColumns = CreateTableCommand.convertNamesToIds(this.colocationColumns, (Object2IntMap<String>)columnIdByName);
        CatalogTableDescriptor cache = CatalogTableDescriptor.builder().cache(true).id(cacheId).schemaId(schema.id()).primaryKeyIndexId(pkIndexId).name(this.cacheName).zoneId(zone.id()).schemaVersions(versions).primaryKeyColumns(pkColumns).colocationColumns(colocationColumns).storageProfile(this.storageProfile).expireColumn(CreateTableCommand.convertNameToId(this.expireColumn, (Object2IntMap<String>)columnIdByName)).expireColumnIndexId(expireColumnIndexId).cacheWriteMode(this.cacheWriteMode).build();
        String indexName = CatalogUtils.pkIndexName(this.cacheName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        CatalogIndexDescriptor pkIndex = this.createPkIndexDescriptor(indexName, pkIndexId, cache);
        updateEntries.add(new NewTableEntry(cache));
        updateEntries.add(new NewIndexEntry(pkIndex));
        updateEntries.add(new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState()));
        if (this.expireColumn != null) {
            String expireColumnIndexName = CatalogUtils.generateNameForExpireColumnIndex(schema, this.cacheName);
            CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, expireColumnIndexName);
            CatalogSortedIndexDescriptor expireColIndex = new CatalogSortedIndexDescriptor(expireColumnIndexId, expireColumnIndexName, cacheId, false, CatalogIndexStatus.AVAILABLE, List.of(new CatalogIndexColumnDescriptor(cache.column(this.expireColumn).id(), CatalogColumnCollation.ASC_NULLS_LAST)), true);
            updateEntries.add(new NewIndexEntry(expireColIndex));
        }
        return updateEntries;
    }

    public List<ColumnParams> columns() {
        return this.columns;
    }

    private void validate() {
        if (CollectionUtils.nullOrEmpty(this.columns)) {
            throw new CatalogValidationException("Cache should have at least one column.");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnParams columnParams : this.columns) {
            if (columnNames.add(columnParams.name())) continue;
            throw new CatalogValidationException("Column with name '{}' specified more than once.", columnParams.name());
        }
        if (this.primaryKey == null || CollectionUtils.nullOrEmpty(this.primaryKey.columns())) {
            throw new CatalogValidationException("Cache should have primary key.");
        }
        this.primaryKey.validate(this.columns);
        for (ColumnParams columnParams : this.columns) {
            boolean partOfPk = this.primaryKey.columns().contains(columnParams.name());
            CatalogUtils.ensureTypeCanBeStored(columnParams.name(), columnParams.type());
            if (partOfPk) {
                CatalogUtils.ensureSupportedDefault(columnParams.name(), columnParams.type(), columnParams.defaultValueDefinition());
            } else {
                CatalogUtils.ensureNonFunctionalDefault(columnParams.name(), columnParams.type(), columnParams.defaultValueDefinition());
            }
            CatalogUtils.ensureSupportedDefault(columnParams);
        }
        if (CollectionUtils.nullOrEmpty(this.colocationColumns)) {
            throw new CatalogValidationException("Colocation columns could not be empty.");
        }
        HashSet<String> colocationColumnsSet = new HashSet<String>();
        for (String name : this.colocationColumns) {
            if (!this.primaryKey.columns().contains(name)) {
                throw new CatalogValidationException("Colocation column '{}' is not part of PK.", name);
            }
            if (colocationColumnsSet.add(name)) continue;
            throw new CatalogValidationException("Colocation column '{}' specified more that once", name);
        }
        if (this.expireColumn != null) {
            Optional<ColumnParams> optional = this.columns.stream().filter(c -> c.name().equals(this.expireColumn)).findAny();
            if (optional.isEmpty()) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column '{}' set as expire column doesn't exist", (Object[])new Object[]{this.expireColumn}));
            }
            if (optional.get().type() != ColumnType.TIMESTAMP) {
                throw new CatalogValidationException("Expire column must be of type TIMESTAMP WITH LOCAL TIME ZONE.");
            }
        }
        if (this.engineResolver == null) {
            throw new CatalogValidationException("Engine resolver is not set.");
        }
    }

    private CatalogIndexDescriptor createPkIndexDescriptor(String indexName, int pkIndexId, CatalogTableDescriptor table) {
        CatalogIndexDescriptor pkIndex;
        if (this.primaryKey instanceof TableSortedPrimaryKey) {
            TableSortedPrimaryKey sortedPrimaryKey = (TableSortedPrimaryKey)this.primaryKey;
            ArrayList<CatalogIndexColumnDescriptor> indexColumns = new ArrayList<CatalogIndexColumnDescriptor>(sortedPrimaryKey.columns().size());
            for (int i = 0; i < sortedPrimaryKey.columns().size(); ++i) {
                String columnName = sortedPrimaryKey.columns().get(i);
                CatalogTableColumnDescriptor column = table.column(columnName);
                assert (column != null) : columnName;
                CatalogColumnCollation collation = sortedPrimaryKey.collations().get(i);
                indexColumns.add(new CatalogIndexColumnDescriptor(column.id(), collation));
            }
            pkIndex = new CatalogSortedIndexDescriptor(pkIndexId, indexName, table.id(), true, CatalogIndexStatus.AVAILABLE, indexColumns, true);
        } else if (this.primaryKey instanceof TableHashPrimaryKey) {
            TableHashPrimaryKey hashPrimaryKey = (TableHashPrimaryKey)this.primaryKey;
            IntArrayList columnIds = new IntArrayList(hashPrimaryKey.columns().size());
            for (String columnName : hashPrimaryKey.columns()) {
                CatalogTableColumnDescriptor column = table.column(columnName);
                assert (column != null) : columnName;
                columnIds.add(column.id());
            }
            pkIndex = new CatalogHashIndexDescriptor(pkIndexId, indexName, table.id(), true, CatalogIndexStatus.AVAILABLE, (IntList)columnIds, true);
        } else {
            throw new IllegalArgumentException("Unexpected primary key type: " + this.primaryKey);
        }
        return pkIndex;
    }

    private static class Builder
    implements CreateCacheCommandBuilder {
        private List<ColumnParams> columns;
        private String schemaName;
        private String cacheName;
        private boolean ifNotExists;
        private TablePrimaryKey primaryKey;
        private List<String> colocationColumns;
        private String zoneName;
        private String storageProfile;
        private String expireColumn;
        private Predicate<String> engineResolver;
        private CacheWriteMode cacheWriteMode = CacheWriteMode.SYNC;

        private Builder() {
        }

        @Override
        public CreateCacheCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder cacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder ifCacheExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder columns(List<ColumnParams> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder primaryKey(TablePrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder colocationColumns(List<String> colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder zone(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder expireColumn(String expireColumn) {
            this.expireColumn = expireColumn;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder engineResolver(Predicate<String> engineResolver) {
            this.engineResolver = engineResolver;
            return this;
        }

        @Override
        public CreateCacheCommandBuilder cacheWriteMode(CacheWriteMode mode) {
            this.cacheWriteMode = mode;
            return this;
        }

        @Override
        public CatalogCommand build() {
            List<String> colocationColumns = this.colocationColumns != null ? this.colocationColumns : (this.primaryKey != null ? this.primaryKey.columns() : null);
            return new CreateCacheCommand(this.cacheName, this.schemaName, this.ifNotExists, this.primaryKey, colocationColumns, this.columns, this.zoneName, this.storageProfile, this.expireColumn, this.engineResolver, this.cacheWriteMode);
        }
    }
}

