/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractCacheCommand;
import org.apache.ignite.internal.catalog.commands.AlterCacheSetExpireCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.SetExpireEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.sql.ColumnType;

public class AlterCacheSetExpireCommand
extends AbstractCacheCommand {
    private final String expireColumn;

    public static AlterCacheSetExpireCommandBuilder builder() {
        return new Builder();
    }

    private AlterCacheSetExpireCommand(String cacheName, String schemaName, boolean ifTableExists, String expireColumn) throws CatalogValidationException {
        super(schemaName, cacheName, ifTableExists);
        this.expireColumn = expireColumn;
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor cache = CatalogUtils.cache(schema, this.cacheName, !this.ifTableExists);
        if (cache == null) {
            return List.of();
        }
        if (this.expireColumn.equals(cache.expireColumn())) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column '{}' already set as expire column.", (Object[])new Object[]{this.expireColumn}));
        }
        CatalogTableColumnDescriptor column = CatalogUtils.columnOrThrow(this.schemaName, cache, this.expireColumn);
        if (column.type() != ColumnType.TIMESTAMP) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Expire column must be of type TIMESTAMP WITH LOCAL TIME ZONE.", (Object[])new Object[]{this.expireColumn}));
        }
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Integer expireColumnIndexId = cache.expireColumnIndexId();
        if (expireColumnIndexId != null) {
            CatalogIndexDescriptor oldIndex = catalog.index(expireColumnIndexId);
            assert (oldIndex != null);
            if (oldIndex.status() != CatalogIndexStatus.STOPPING) {
                updateEntries.add(DropIndexCommand.updateEntryForIndex(oldIndex));
            }
        }
        String indexName = CatalogUtils.generateNameForExpireColumnIndex(schema, this.cacheName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        int id = catalog.objectIdGenState();
        int expireIdxId = id++;
        CatalogSortedIndexDescriptor expireColIndex = new CatalogSortedIndexDescriptor(expireIdxId, indexName, cache.id(), false, List.of(new CatalogIndexColumnDescriptor(column.id(), CatalogColumnCollation.ASC_NULLS_LAST)));
        updateEntries.addAll(List.of(new NewIndexEntry(expireColIndex), new SetExpireEntry(cache.id(), this.expireColumn, expireIdxId), new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState())));
        return updateEntries;
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.expireColumn, "Name of the column");
    }

    private static class Builder
    implements AlterCacheSetExpireCommandBuilder {
        private String expireColumn;
        private String schemaName;
        private boolean ifTableExists;
        private String cacheName;

        private Builder() {
        }

        @Override
        public AlterCacheSetExpireCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterCacheSetExpireCommandBuilder cacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        @Override
        public AlterCacheSetExpireCommandBuilder ifCacheExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterCacheSetExpireCommand(this.cacheName, this.schemaName, this.ifTableExists, this.expireColumn);
        }

        @Override
        public AlterCacheSetExpireCommandBuilder expireColumn(String expireColumn) {
            this.expireColumn = expireColumn;
            return this;
        }
    }
}

