/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.storage.AbstractUpdateTableEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

abstract class ModifyTableExpireEntry
extends AbstractUpdateTableEntry
implements Fireable {
    protected final int tableId;
    @Nullable
    protected final String expireColumn;
    @Nullable
    protected final Integer expireColumnIndexId;

    ModifyTableExpireEntry(int tableId, @Nullable String expireColumn, @Nullable Integer expireColumnIndexId) {
        assert (expireColumn == null == (expireColumnIndexId == null)) : "expireColumn=" + expireColumn + ", expireColumnIndexId=" + expireColumnIndexId;
        this.tableId = tableId;
        this.expireColumn = expireColumn;
        this.expireColumnIndexId = expireColumnIndexId;
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        CatalogTableDescriptor.Builder newTable = table.copyBuilder();
        if (this.expireColumn == null) {
            newTable.expireColumn(null).expireColumnIndexId(null);
        } else {
            newTable.expireColumn(table.column(this.expireColumn).id()).expireColumnIndexId(this.expireColumnIndexId);
        }
        return newTable;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

