/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.storage.LockTableAccessEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class LockTableAccessEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class LockTableAccessEntrySerializerV2
    implements CatalogObjectSerializer<LockTableAccessEntry> {
        LockTableAccessEntrySerializerV2() {
        }

        @Override
        public LockTableAccessEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            boolean lock = input.readBoolean();
            return new LockTableAccessEntry(tableId, lock);
        }

        @Override
        public void writeTo(LockTableAccessEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.tableId());
            output.writeBoolean(entry.lock());
        }
    }
}

