/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropColumnEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractUpdateTableEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;

public class DropColumnsEntry
extends AbstractUpdateTableEntry
implements Fireable {
    private final int tableId;
    private final Set<String> columns;

    public DropColumnsEntry(int tableId, Set<String> columns) {
        this.tableId = tableId;
        this.columns = columns;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public Set<String> columns() {
        return this.columns;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_COLUMN.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropColumnEventParameters(causalityToken, catalogVersion, this.tableId, this.columns);
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        List<CatalogTableColumnDescriptor> updatedTableColumns = table.columns().stream().filter(col -> !this.columns.contains(col.name())).collect(Collectors.toList());
        return table.copyBuilder().newColumns(updatedTableColumns);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

