/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.AddSecondaryZoneEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractUpdateTableEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;

public class AddSecondaryZoneEntry
extends AbstractUpdateTableEntry
implements Fireable {
    private final int tableId;
    private final int secondaryZoneId;
    private final String secondaryStorageProfile;

    public AddSecondaryZoneEntry(int tableId, int secondaryZoneId, String secondaryStorageProfile) {
        this.tableId = tableId;
        this.secondaryZoneId = secondaryZoneId;
        this.secondaryStorageProfile = secondaryStorageProfile;
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        return table.copyBuilder().secondaryZoneId(this.secondaryZoneId).secondaryStorageProfile(this.secondaryStorageProfile).secondaryStorageState(CatalogSecondaryStorageState.SYNCING);
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public int secondaryZoneId() {
        return this.secondaryZoneId;
    }

    public String secondaryStorageProfile() {
        return this.secondaryStorageProfile;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new AddSecondaryZoneEventParameters(causalityToken, catalogVersion, this.tableId, this.secondaryZoneId, this.secondaryStorageProfile);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ADD_SECONDARY_ZONE.id();
    }
}

