/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.SwitchTableAccessCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.LockTableAccessEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class SwitchTableAccessCommand
extends AbstractTableCommand {
    private final boolean lock;

    public static SwitchTableAccessCommandBuilder builder() {
        return new Builder();
    }

    private SwitchTableAccessCommand(String schemaName, String tableName, boolean ifTableExists, boolean lock, boolean validateSystemSchemas) {
        super(schemaName, tableName, ifTableExists, validateSystemSchemas);
        this.lock = lock;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogTableDescriptor table = schema.table(this.tableName);
        if (table == null || table.cache()) {
            throw new CatalogValidationException("Table with name '{}.{}' not found", schema.name(), this.tableName);
        }
        return this.lock ^ table.isLockedForAccess() ? List.of(new LockTableAccessEntry(table.id(), this.lock)) : List.of();
    }

    private static class Builder
    implements SwitchTableAccessCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;
        private boolean lock;
        private boolean validateSystemSchemas = true;

        private Builder() {
        }

        @Override
        public SwitchTableAccessCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public SwitchTableAccessCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public SwitchTableAccessCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public SwitchTableAccessCommandBuilder lock(boolean lock) {
            this.lock = lock;
            return this;
        }

        @Override
        public SwitchTableAccessCommandBuilder validateSystemSchemas(boolean validateSystemSchemas) {
            this.validateSystemSchemas = validateSystemSchemas;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new SwitchTableAccessCommand(this.schemaName, this.tableName, this.ifTableExists, this.lock, this.validateSystemSchemas);
        }
    }
}

