/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.AlterTablePropertiesEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractUpdateTableEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class AlterTablePropertiesEntry
extends AbstractUpdateTableEntry
implements Fireable {
    private final int tableId;
    @Nullable
    private final Double staleRowsFraction;
    @Nullable
    private final Long minStaleRowsCount;

    public AlterTablePropertiesEntry(int tableId, @Nullable Double staleRowsFraction, @Nullable Long minStaleRowsCount) {
        this.tableId = tableId;
        this.staleRowsFraction = staleRowsFraction;
        this.minStaleRowsCount = minStaleRowsCount;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ALTER_TABLE_PROPERTIES.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new AlterTablePropertiesEventParameters(causalityToken, catalogVersion, this);
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        CatalogTableDescriptor.Builder builder = table.copyBuilder();
        if (this.minStaleRowsCount != null) {
            builder.minStaleRowsCount(this.minStaleRowsCount);
        }
        if (this.staleRowsFraction != null) {
            builder.staleRowsFraction(this.staleRowsFraction);
        }
        return builder;
    }

    @Nullable
    public Double staleRowsFraction() {
        return this.staleRowsFraction;
    }

    @Nullable
    public Long minStaleRowsCount() {
        return this.minStaleRowsCount;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

