/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.S;

public class CatalogSortedIndexDescriptor
extends CatalogIndexDescriptor {
    private final List<CatalogIndexColumnDescriptor> columns;

    public CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, List<CatalogIndexColumnDescriptor> columns) {
        this(id, name, tableId, unique, CatalogIndexStatus.REGISTERED, columns, false);
    }

    public CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<CatalogIndexColumnDescriptor> columns, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, columns, CatalogManager.INITIAL_TIMESTAMP, isCreatedWithTable);
    }

    CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<CatalogIndexColumnDescriptor> columns, HybridTimestamp timestamp, boolean isCreatedWithTable) {
        super(CatalogIndexDescriptor.CatalogIndexDescriptorType.SORTED, id, name, tableId, unique, status, timestamp, isCreatedWithTable);
        this.columns = Objects.requireNonNull(columns, "columns");
    }

    public List<CatalogIndexColumnDescriptor> columns() {
        return this.columns;
    }

    @Override
    public CatalogSortedIndexDescriptor upgradeIfNeeded(CatalogTableDescriptor table) {
        if (this.columns.isEmpty() || this.columns.get(0).name() == null) {
            return this;
        }
        assert (this.tableId() == table.id());
        ArrayList<CatalogIndexColumnDescriptor> upgradedColumns = new ArrayList<CatalogIndexColumnDescriptor>(this.columns.size());
        for (CatalogIndexColumnDescriptor indexColumn : this.columns) {
            String columnName = indexColumn.name();
            assert (columnName != null);
            CatalogTableColumnDescriptor column = table.column(columnName);
            assert (column != null) : columnName;
            upgradedColumns.add(new CatalogIndexColumnDescriptor(column.id(), indexColumn.collation()));
        }
        return new CatalogSortedIndexDescriptor(this.id(), this.name(), this.tableId(), this.unique(), this.status(), upgradedColumns, this.updateTimestamp(), this.isCreatedWithTable());
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_SORTED_INDEX.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogSortedIndexDescriptor.class, (Object)this, (String)super.toString());
    }
}

