/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog;

import java.util.function.Function;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.NoOpCatalogManagerImpl;
import org.jetbrains.annotations.TestOnly;

public class UpdateContext {
    private final Catalog baseCatalog;
    private Catalog updatableCatalog;
    private final CatalogService catalogService;

    @TestOnly
    public UpdateContext(Catalog catalog) {
        this(catalog, new NoOpCatalogManagerImpl());
    }

    public UpdateContext(Catalog catalog, CatalogService catalogService) {
        this.baseCatalog = catalog;
        this.updatableCatalog = catalog;
        this.catalogService = catalogService;
    }

    public Catalog catalog() {
        return this.updatableCatalog;
    }

    public Catalog baseCatalog() {
        return this.baseCatalog;
    }

    public void updateCatalog(Function<Catalog, Catalog> updater) {
        this.updatableCatalog = updater.apply(this.updatableCatalog);
    }

    public CatalogService catalogService() {
        return this.catalogService;
    }
}

